/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.complaints.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.complaints.entity.ComplaintsEntity;
import com.biz.crm.complaints.mapper.ComplaintsMapper;
import com.biz.crm.complaints.service.ComplaintsContentService;
import com.biz.crm.complaints.service.ComplaintsFileService;
import com.biz.crm.complaints.service.ComplaintsService;
import com.biz.crm.complaints.utils.ComplaintsOrderNoUtils;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.dms.ComplaintsEunm;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.dms.complaints.ComplaintsFileVo;
import com.biz.crm.nebular.dms.complaints.ComplaintsReplyVo;
import com.biz.crm.nebular.dms.complaints.ComplaintsRes;
import com.biz.crm.nebular.dms.complaints.ComplaintsVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"complaintsServiceExpandImpl"})
@Service(value="complaintsService")
public class ComplaintsServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<ComplaintsMapper, ComplaintsEntity>
implements ComplaintsService {
    @Resource
    private ComplaintsMapper complaintsMapper;
    @Resource
    private ComplaintsContentService complaintsContentService;
    @Resource
    private ComplaintsFileService complaintsFileService;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Override
    @Transactional
    public void add(ComplaintsVo ComplaintsVo2) {
        ValidateUtils.validate((Object)ComplaintsVo2.getComplaintsTitle(), (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)ComplaintsVo2.getComplaintsType(), (String)"\u8bf7\u6307\u5b9a\u7c7b\u578b!");
        ValidateUtils.validate((Object)ComplaintsVo2.getContent(), (String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
        String orderNo = ComplaintsOrderNoUtils.getOrderIdByTime();
        ComplaintsEntity complaintsEntity = new ComplaintsEntity();
        BeanUtils.copyProperties((Object)ComplaintsVo2, (Object)complaintsEntity);
        UserRedis userRedis = UserUtils.getUser();
        complaintsEntity.setComplaintsNo(orderNo);
        complaintsEntity.setCustomerCode(userRedis.getCustcode());
        complaintsEntity.setCustomerName(userRedis.getCustname());
        complaintsEntity.setComplaintsStatus(String.valueOf(ComplaintsEunm.ComplaintsStatusEnum.FACTORY.getCode()));
        this.complaintsMapper.insert(complaintsEntity);
        this.complaintsContentService.add(complaintsEntity.getId(), ComplaintsVo2.getContent(), ComplaintsEunm.ComplaintsSubTypeEnum.CUSTOMER.getValue());
        if (null != ComplaintsVo2.getFiles()) {
            this.complaintsFileService.add(complaintsEntity, ComplaintsVo2.getFiles());
        }
    }

    @Override
    @Transactional
    public void replyComplaints(ComplaintsReplyVo complaintsReplyVo, String flag) {
        ValidateUtils.validate((Object)complaintsReplyVo.getComplaintsId(), (String)"\u6295\u8bc9\u5efa\u8baeid\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)complaintsReplyVo.getContent(), (String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
        this.complaintsContentService.add(complaintsReplyVo.getComplaintsId(), complaintsReplyVo.getContent(), flag);
        ComplaintsEntity complaintsEntity = (ComplaintsEntity)this.complaintsMapper.selectById((Serializable)((Object)complaintsReplyVo.getComplaintsId()));
        complaintsEntity.setComplaintsStatus(flag);
        this.complaintsMapper.updateById(complaintsEntity);
    }

    @Override
    @Transactional
    public void solveComplaints(String complaintsId) {
        ValidateUtils.validate((Object)complaintsId, (String)"\u6295\u8bc9\u5efa\u8baeid\u4e0d\u80fd\u4e3a\u7a7a!");
        ComplaintsEntity complaintsEntity = (ComplaintsEntity)this.complaintsMapper.selectById((Serializable)((Object)complaintsId));
        complaintsEntity.setComplaintsStatus(String.valueOf(ComplaintsEunm.ComplaintsStatusEnum.FINISHED.getCode()));
        this.complaintsMapper.updateById(complaintsEntity);
    }

    @Override
    @CrmDictMethod
    public PageResult<ComplaintsVo> list(ComplaintsVo complaintsVo) {
        Page page = PageUtil.buildPage((Integer)complaintsVo.getPageNum(), (Integer)complaintsVo.getPageSize());
        List<ComplaintsVo> list = this.complaintsMapper.list(page, complaintsVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmDictMethod
    public ComplaintsRes detailById(String id, String flag) {
        ValidateUtils.validate((Object)id, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u6295\u8bc9\u5efa\u8bae\uff01");
        ComplaintsEntity complaintsEntity = (ComplaintsEntity)this.complaintsMapper.selectById((Serializable)((Object)id));
        ValidateUtils.validate((Object)complaintsEntity, (String)"\u8fd9\u6761\u6295\u8bc9\u5efa\u8bae\u4e0d\u5b58\u5728\uff01");
        ComplaintsVo complaintsVo = new ComplaintsVo();
        BeanUtils.copyProperties((Object)complaintsEntity, (Object)complaintsVo);
        List<ComplaintsReplyVo> complaintsReplyVos = this.complaintsContentService.contentById(complaintsEntity.getId());
        List<ComplaintsFileVo> complaintsFileVos = this.complaintsFileService.filesById(complaintsEntity.getId());
        complaintsVo.setFiles(complaintsFileVos);
        ComplaintsRes complaintsRes = new ComplaintsRes();
        complaintsRes.setComplaintsVo(complaintsVo);
        complaintsRes.setReplyVos(complaintsReplyVos);
        if (flag.equals(ComplaintsEunm.ComplaintsStatusEnum.FACTORY.getValue())) {
            MdmCustomerMsgRespVo customerInfo = (MdmCustomerMsgRespVo)this.mdmCustomerMsgFeign.query(null, complaintsEntity.getCustomerCode()).getResult();
            complaintsRes.setCustomerInfo(customerInfo);
        }
        return complaintsRes;
    }
}

