/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.complaints.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.complaints.entity.ComplaintsContentEntity;
import com.biz.crm.complaints.mapper.ComplaintsContentMapper;
import com.biz.crm.complaints.service.ComplaintsContentService;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.dms.ComplaintsEunm;
import com.biz.crm.nebular.dms.complaints.ComplaintsReplyVo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"complaintsContentServiceExpandImpl"})
@Service(value="complaintsContentService")
public class ComplaintsContentServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<ComplaintsContentMapper, ComplaintsContentEntity>
implements ComplaintsContentService {
    @Resource
    private ComplaintsContentMapper complaintsContentMapper;

    @Override
    @Transactional
    public void add(String complaintsId, String content, String flag) {
        ComplaintsContentEntity complaintsContentEntity = new ComplaintsContentEntity();
        complaintsContentEntity.setComplaintsId(complaintsId);
        complaintsContentEntity.setContent(content);
        if (flag.equals(ComplaintsEunm.ComplaintsSubTypeEnum.CUSTOMER.getValue())) {
            complaintsContentEntity.setSubmitterType(String.valueOf(ComplaintsEunm.ComplaintsSubTypeEnum.CUSTOMER.getCode()));
        } else {
            complaintsContentEntity.setSubmitterType(String.valueOf(ComplaintsEunm.ComplaintsSubTypeEnum.FACTORY.getCode()));
        }
        this.complaintsContentMapper.insert(complaintsContentEntity);
    }

    @Override
    @CrmDictMethod
    public List<ComplaintsReplyVo> contentById(String complaintsId) {
        List contentEntities = this.complaintsContentMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"complaints_id", (Object)complaintsId)).orderByAsc((Object)"create_date_all"));
        ArrayList<ComplaintsReplyVo> complaintsReplyVos = new ArrayList<ComplaintsReplyVo>();
        for (ComplaintsContentEntity contentEntity : contentEntities) {
            ComplaintsReplyVo complaintsReplyVo = new ComplaintsReplyVo();
            BeanUtils.copyProperties((Object)contentEntity, (Object)complaintsReplyVo);
            complaintsReplyVo.setSubmitter(contentEntity.getCreateName());
            complaintsReplyVos.add(complaintsReplyVo);
        }
        return complaintsReplyVos;
    }
}

