/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salecontract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.dms.salecontract.ContractTemplateTupleMappingVo;
import com.biz.crm.nebular.dms.salecontract.ContractTupleVo;
import com.biz.crm.salecontract.entity.ContractTemplateTupleMappingEntity;
import com.biz.crm.salecontract.mapper.ContractTemplateTupleMappingMapper;
import com.biz.crm.salecontract.service.ContractTemplateTupleMappingService;
import com.biz.crm.salecontract.util.ContractTemplateUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"contractTemplateTupleMappingServiceImpl"})
@Service(value="contractTemplateTupleMappingService")
public class ContractTemplateTupleMappingServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<ContractTemplateTupleMappingMapper, ContractTemplateTupleMappingEntity>
implements ContractTemplateTupleMappingService {
    @Resource
    private ContractTemplateTupleMappingMapper contractTemplateTupleMappingMapper;

    @Override
    @Transactional
    public List<ContractTemplateTupleMappingVo> replace(List<ContractTupleVo> tupleVos, String templateCode) {
        ValidateUtils.validate((Object)templateCode, (String)"\u65b0\u589e/\u66f4\u65b0\u6a21\u677f\u5143\u7ec4\u6620\u5c04\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtil.listEmpty(tupleVos)) {
            return Lists.newArrayList();
        }
        List<ContractTemplateTupleMappingVo> dbMappings = this.findMappingByTemplateCode(templateCode);
        List<ContractTemplateTupleMappingVo> dbEnableMapping = dbMappings.stream().filter(mapping -> Objects.equals(CrmEnableStatusEnum.ENABLE.getCode(), mapping.getDelFlag())).collect(Collectors.toList());
        List dbDisabledMapping = dbMappings.stream().filter(mapping -> Objects.equals(CrmEnableStatusEnum.DISABLE.getCode(), mapping.getDelFlag())).collect(Collectors.toList());
        List<ContractTemplateTupleMappingVo> mappingVos = ContractTemplateUtil.buildTemplateTupleMappingVo(tupleVos, templateCode);
        List<String> addTupleCodes = this.difference(mappingVos, dbMappings);
        List<ContractTemplateTupleMappingVo> addMappings = mappingVos.stream().filter(mapping -> addTupleCodes.contains(mapping.getTupleCode())).collect(Collectors.toList());
        addMappings.forEach(mapping -> mapping.setIndexCode(CodeUtil.getCode()));
        this.saveBatch(CrmBeanUtil.copyList(addMappings, ContractTemplateTupleMappingEntity.class));
        List<ContractTemplateTupleMappingVo> updateTuples = this.beMixed(dbMappings, mappingVos);
        this.updateBatchById(CrmBeanUtil.copyList(updateTuples, ContractTemplateTupleMappingEntity.class));
        List<String> disabledTupleCodes = this.difference(dbEnableMapping, mappingVos);
        List<ContractTemplateTupleMappingVo> disabledMappings = dbEnableMapping.stream().filter(mapping -> disabledTupleCodes.contains(mapping.getTupleCode())).collect(Collectors.toList());
        disabledMappings.forEach(mapping -> mapping.setDelFlag(CrmEnableStatusEnum.DISABLE.getCode()));
        this.updateBatchById(CrmBeanUtil.copyList(disabledMappings, ContractTemplateTupleMappingEntity.class));
        ArrayList enableTupleCodes = Lists.newArrayList(mappingVos.stream().collect(Collectors.toMap(ContractTemplateTupleMappingVo::getTupleCode, a -> a, (a, b) -> b)).keySet());
        List<ContractTemplateTupleMappingVo> enableMappings = dbDisabledMapping.stream().filter(mapping -> enableTupleCodes.contains(mapping.getTupleCode())).collect(Collectors.toList());
        enableMappings.forEach(mapping -> mapping.setDelFlag(CrmEnableStatusEnum.ENABLE.getCode()));
        this.updateBatchById(CrmBeanUtil.copyList(enableMappings, ContractTemplateTupleMappingEntity.class));
        return mappingVos;
    }

    private List<ContractTemplateTupleMappingVo> beMixed(List<ContractTemplateTupleMappingVo> source, List<ContractTemplateTupleMappingVo> target) {
        Map<String, ContractTemplateTupleMappingVo> sourceMap = source.stream().collect(Collectors.toMap(ContractTemplateTupleMappingVo::getTupleCode, a -> a, (c, d) -> d));
        Map<String, ContractTemplateTupleMappingVo> targetMap = target.stream().collect(Collectors.toMap(ContractTemplateTupleMappingVo::getTupleCode, a -> a, (c, d) -> d));
        ArrayList result = Lists.newArrayList();
        sourceMap.forEach((k, v) -> {
            if (targetMap.containsKey(k)) {
                ContractTemplateTupleMappingVo targetValue = (ContractTemplateTupleMappingVo)targetMap.get(k);
                targetValue.setId(v.getId());
                result.add(targetValue);
            }
        });
        return result;
    }

    private List<String> difference(List<ContractTemplateTupleMappingVo> dbVos, List<ContractTemplateTupleMappingVo> vos) {
        Set<String> tupleCodes;
        Set<String> dbTupleCodes = dbVos.stream().collect(Collectors.groupingBy(ContractTemplateTupleMappingVo::getTupleCode)).keySet();
        Sets.SetView differenceIds = Sets.difference(dbTupleCodes, tupleCodes = vos.stream().filter(vo -> StringUtils.isNotEmpty((String)vo.getTupleCode())).collect(Collectors.groupingBy(ContractTemplateTupleMappingVo::getTupleCode)).keySet());
        if (!CollectionUtil.collectionNotEmpty((Collection)differenceIds)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)differenceIds);
    }

    @Override
    public List<ContractTupleVo> findTupleByTemplateCode(String templateCode) {
        if (StringUtils.isEmpty((String)templateCode)) {
            return Lists.newArrayList();
        }
        List<ContractTupleVo> contractTupleVos = this.contractTemplateTupleMappingMapper.findTupleByTemplateCode(templateCode);
        return contractTupleVos;
    }

    @Override
    public List<ContractTemplateTupleMappingVo> findMappingByTemplateCode(String templateCode) {
        if (StringUtils.isEmpty((String)templateCode)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"template_code", (Object)templateCode);
        List entities = this.contractTemplateTupleMappingMapper.selectList((Wrapper)wrapper);
        return CrmBeanUtil.copyList((List)entities, ContractTemplateTupleMappingVo.class);
    }

    @Override
    public List<ContractTemplateTupleMappingVo> findByTupleCode(String tupleCode) {
        if (StringUtils.isEmpty((String)tupleCode)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"tuple_code", (Object)tupleCode);
        List entities = this.list((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        return CrmBeanUtil.copyList((List)entities, ContractTemplateTupleMappingVo.class);
    }
}

