/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.complaints.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.complaints.entity.ComplaintsEntity;
import com.biz.crm.complaints.entity.ComplaintsFileEntity;
import com.biz.crm.complaints.mapper.ComplaintsFileMapper;
import com.biz.crm.complaints.service.ComplaintsFileService;
import com.biz.crm.nebular.dms.complaints.ComplaintsFileVo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"complaintsFileServiceExpandImpl"})
@Service(value="complaintsFileService")
public class ComplaintsFileServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<ComplaintsFileMapper, ComplaintsFileEntity>
implements ComplaintsFileService {
    @Resource
    private ComplaintsFileMapper complaintsFileMapper;

    @Override
    @Transactional
    public void add(ComplaintsEntity entity, List<ComplaintsFileVo> files) {
        if (CollectionUtils.isEmpty(files)) {
            return;
        }
        ArrayList<ComplaintsFileEntity> entities = new ArrayList<ComplaintsFileEntity>(files.size());
        int i = 0;
        for (ComplaintsFileVo vo : files) {
            vo.setSortNum(Integer.valueOf(++i));
            ComplaintsFileEntity fileEntity = new ComplaintsFileEntity();
            BeanUtils.copyProperties((Object)vo, (Object)fileEntity);
            fileEntity.setComplaintsId(entity.getId());
            entities.add(fileEntity);
        }
        this.saveBatch(entities);
    }

    @Override
    public List<ComplaintsFileVo> filesById(String id) {
        List complaintsFiles = this.complaintsFileMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"complaints_id", (Object)id)).orderByAsc((Object)"create_date_all"));
        ArrayList<ComplaintsFileVo> complaintsFileVos = new ArrayList<ComplaintsFileVo>();
        for (ComplaintsFileEntity complaintsFile : complaintsFiles) {
            ComplaintsFileVo complaintsFileVo = new ComplaintsFileVo();
            BeanUtils.copyProperties((Object)complaintsFile, (Object)complaintsFileVo);
            complaintsFileVos.add(complaintsFileVo);
        }
        return complaintsFileVos;
    }
}

