/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rotationpic.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.dms.rotationpic.DmsRotationPicAreaVo;
import com.biz.crm.rotationpic.entity.RotationPicAreaEntity;
import com.biz.crm.rotationpic.mapper.RotationPicAreaMapper;
import com.biz.crm.rotationpic.service.RotationPicAreaService;
import com.biz.crm.rotationpic.util.RotationPicAreaUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"rotationPicAreaServiceExpandImpl"})
@Service(value="rotationPicAreaService")
public class RotationPicAreaServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RotationPicAreaMapper, RotationPicAreaEntity>
implements RotationPicAreaService {
    @Autowired
    private RotationPicAreaMapper rotationPicAreaMapper;

    @Override
    @Transactional
    public void replace(List<DmsRotationPicAreaVo> areas, List<DmsRotationPicAreaVo> noAreas, final String rotationPicId) {
        ArrayList<DmsRotationPicAreaVo> allArea = new ArrayList<DmsRotationPicAreaVo>();
        if (!CollectionUtils.isEmpty(areas)) {
            allArea.addAll(areas);
        }
        if (!CollectionUtils.isEmpty(noAreas)) {
            allArea.addAll(noAreas);
        }
        RotationPicAreaUtil.validateList(allArea);
        List entities = this.rotationPicAreaMapper.selectByMap(new HashMap<String, Object>(){
            {
                this.put("rotation_pic_id", rotationPicId);
            }
        });
        List<DmsRotationPicAreaVo> addAreas = RotationPicAreaUtil.filterAddVos(allArea, entities);
        List<String> delIds = RotationPicAreaUtil.filterDelVos(allArea, entities);
        if (!CollectionUtils.isEmpty(delIds)) {
            QueryWrapper wrapper = (QueryWrapper)Wrappers.query().in((Object)"id", delIds);
            this.rotationPicAreaMapper.delete((Wrapper)wrapper);
        }
        if (!CollectionUtils.isEmpty(addAreas)) {
            this.saveBatch(RotationPicAreaUtil.packageRntities(addAreas, rotationPicId));
        }
    }

    @Override
    public Map<String, Map<String, List<DmsRotationPicAreaVo>>> findAreaByRotationPicIds(List<String> rotationPicIds) {
        if (CollectionUtils.isEmpty(rotationPicIds)) {
            return new HashMap<String, Map<String, List<DmsRotationPicAreaVo>>>();
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().in((Object)"rotation_pic_id", rotationPicIds);
        List entities = this.rotationPicAreaMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return new HashMap<String, Map<String, List<DmsRotationPicAreaVo>>>();
        }
        HashMap<String, Map<String, List<DmsRotationPicAreaVo>>> reMap = new HashMap<String, Map<String, List<DmsRotationPicAreaVo>>>();
        for (String rotationPicId : rotationPicIds) {
            final ArrayList<DmsRotationPicAreaVo> area = new ArrayList<DmsRotationPicAreaVo>();
            final ArrayList<DmsRotationPicAreaVo> noArea = new ArrayList<DmsRotationPicAreaVo>();
            HashMap<String, List<DmsRotationPicAreaVo>> map = new HashMap<String, List<DmsRotationPicAreaVo>>(){
                {
                    this.put("area", area);
                    this.put("noArea", noArea);
                }
            };
            reMap.put(rotationPicId, (Map<String, List<DmsRotationPicAreaVo>>)map);
            List entityList = entities.stream().filter(entity -> entity.getRotationPicId().equals(rotationPicId)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(entityList)) continue;
            for (RotationPicAreaEntity entity2 : entityList) {
                DmsRotationPicAreaVo vo = new DmsRotationPicAreaVo();
                BeanUtils.copyProperties((Object)((Object)entity2), (Object)vo);
                if (vo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()) {
                    area.add(vo);
                    continue;
                }
                noArea.add(vo);
            }
        }
        return reMap;
    }

    @Override
    public Map<String, List<DmsRotationPicAreaVo>> findAreaByRotationPicId(final String rotationPicId) {
        final ArrayList<DmsRotationPicAreaVo> area = new ArrayList<DmsRotationPicAreaVo>();
        final ArrayList<DmsRotationPicAreaVo> noArea = new ArrayList<DmsRotationPicAreaVo>();
        HashMap<String, List<DmsRotationPicAreaVo>> reMap = new HashMap<String, List<DmsRotationPicAreaVo>>(){
            {
                this.put("area", area);
                this.put("noArea", noArea);
            }
        };
        if (StringUtils.isEmpty((String)rotationPicId)) {
            return reMap;
        }
        List entities = this.rotationPicAreaMapper.selectByMap(new HashMap<String, Object>(){
            {
                this.put("rotation_pic_id", rotationPicId);
            }
        });
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return reMap;
        }
        for (RotationPicAreaEntity entity : entities) {
            DmsRotationPicAreaVo vo = new DmsRotationPicAreaVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            if (vo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()) {
                area.add(vo);
                continue;
            }
            noArea.add(vo);
        }
        return reMap;
    }

    @Override
    @Transactional
    public void delByRotationPicIds(List<String> rotationPicIds) {
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().in((Object)"rotation_pic_id", rotationPicIds);
        this.rotationPicAreaMapper.delete((Wrapper)wrapper);
    }
}

