/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salecontract.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.contractupdatingfiles.service.ContractUpdatingFilesService;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.dms.contractupdatingfiles.ContractUpdatingFilesVo;
import com.biz.crm.nebular.dms.salecontract.ContractTemplateVo;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.salecontract.entity.SaleContractEntity;
import com.biz.crm.salecontract.mapper.SaleContractMapper;
import com.biz.crm.salecontract.service.ContractTemplateService;
import com.biz.crm.salecontract.service.ContractTupleService;
import com.biz.crm.salecontract.service.SaleContractService;
import com.biz.crm.salecontract.service.extral.SaleContractValidator;
import com.biz.crm.salecontract.service.listener.AbstractContractModelListener;
import com.biz.crm.salecontract.util.SaleContractUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="saleContractService")
@ConditionalOnMissingBean(name={"saleContractServiceImpl"})
public class SaleContractServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SaleContractMapper, SaleContractEntity>
implements SaleContractService {
    @Resource
    private SaleContractMapper saleContractMapper;
    @Resource
    private ContractTemplateService contractTemplateService;
    @Resource
    private ContractTupleService contractTupleService;
    @Resource
    private ContractUpdatingFilesService contractUpdatingFilesService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Autowired(required=false)
    private List<SaleContractValidator> saleContractValidators;

    @Override
    @Transactional
    public SaleContractVo add(SaleContractVo saleContractVo) {
        if (CollectionUtil.listNotEmpty(this.saleContractValidators)) {
            this.saleContractValidators.forEach(saleContractValidator -> saleContractValidator.validateAdd(saleContractVo));
        }
        SaleContractUtil.validateAdd(saleContractVo);
        saleContractVo.setCode(CodeUtil.generateCode());
        ContractTemplateVo contractTemplateVo = this.contractTemplateService.findDetailsByCode(saleContractVo.getTemplateCode());
        ValidateUtils.validate((Object)contractTemplateVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6a21\u677f");
        ValidateUtils.notEmpty((Collection)contractTemplateVo.getTuples(), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6a21\u677f\u5143\u7ec4\u5217\u8868", (String[])new String[0]);
        SaleContractEntity entity = (SaleContractEntity)((Object)CrmBeanUtil.copy((Object)saleContractVo, SaleContractEntity.class));
        boolean addResult = this.save((Object)entity);
        ValidateUtils.isTrue((boolean)addResult, (String)"\u65b0\u589e\u5408\u540c\u5931\u8d25", (Object[])new Object[0]);
        saleContractVo.setId(entity.getId());
        List tupleVos = contractTemplateVo.getTuples();
        JSONObject data = saleContractVo.getData();
        tupleVos.forEach(tuple -> {
            AbstractContractModelListener contractListenerService = this.contractTupleService.getTupleBean(tuple.getBeanName());
            if (contractListenerService != null && data.getJSONArray(tuple.getJsonName()) != null && data.getJSONArray(tuple.getJsonName()).size() > 0) {
                JSONArray jsonArray = data.getJSONArray(tuple.getJsonName());
                ValidateUtils.validate((Object)(CollectionUtil.listEmpty((List)jsonArray) || jsonArray.size() == 1 ? 1 : 0), (String)"\u6a21\u5757%s\u53ea\u80fd\u4f20\u5165\u4e00\u6761\u8bb0\u5f55", (Object[])new Object[]{tuple.getName()});
                JSONArray result = contractListenerService.add(jsonArray, saleContractVo.getCode(), tuple.getJsonName(), saleContractVo, tuple.getIndexCode());
                data.put(tuple.getJsonName(), (Object)result);
            }
        });
        if (CollectionUtil.listNotEmpty((List)saleContractVo.getFilesVo())) {
            this.contractUpdatingFilesService.replace(saleContractVo.getFilesVo(), saleContractVo.getCode());
        }
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        SaleContractVo logVo = this.findDetailByCode(entity.getCode());
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), logVo.getId(), logVo.getCode(), (Object)logVo);
        return saleContractVo;
    }

    @Override
    @Transactional
    public SaleContractVo edit(SaleContractVo saleContractVo) {
        if (CollectionUtil.listNotEmpty(this.saleContractValidators)) {
            this.saleContractValidators.forEach(saleContractValidator -> saleContractValidator.validateEdit(saleContractVo));
        }
        SaleContractUtil.validateEdit(saleContractVo);
        ContractTemplateVo contractTemplateVo = this.contractTemplateService.findDetailsByCode(saleContractVo.getTemplateCode());
        ValidateUtils.validate((Object)contractTemplateVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6a21\u677f");
        ValidateUtils.notEmpty((Collection)contractTemplateVo.getTuples(), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6a21\u677f\u5143\u7ec4\u5217\u8868", (String[])new String[0]);
        List tupleVos = contractTemplateVo.getTuples();
        JSONObject data = saleContractVo.getData();
        SaleContractVo oldObject = this.findDetailByCode(saleContractVo.getCode());
        tupleVos.forEach(tuple -> {
            AbstractContractModelListener contractListenerService = this.contractTupleService.getTupleBean(tuple.getBeanName());
            if (contractListenerService != null && data.getJSONArray(tuple.getJsonName()) != null && data.getJSONArray(tuple.getJsonName()).size() > 0) {
                JSONArray jsonArray = data.getJSONArray(tuple.getJsonName());
                ValidateUtils.validate((Object)(CollectionUtil.listEmpty((List)jsonArray) || jsonArray.size() == 1 ? 1 : 0), (String)"\u6a21\u5757%s\u53ea\u80fd\u4f20\u5165\u4e00\u6761\u8bb0\u5f55", (Object[])new Object[]{tuple.getName()});
                JSONArray result = contractListenerService.edit(jsonArray, saleContractVo.getCode(), tuple.getJsonName(), saleContractVo, tuple.getIndexCode());
                data.put(tuple.getJsonName(), (Object)result);
            }
        });
        boolean editResult = this.updateById(CrmBeanUtil.copy((Object)saleContractVo, SaleContractEntity.class));
        ValidateUtils.validate((Object)editResult, (String)"\u66f4\u65b0\u5408\u540c\u5931\u8d25");
        if (CollectionUtil.listNotEmpty((List)saleContractVo.getFilesVo())) {
            this.contractUpdatingFilesService.replace(saleContractVo.getFilesVo(), saleContractVo.getCode());
        }
        SaleContractVo newObject = saleContractVo;
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newObject.getId(), newObject.getCode(), (Object)oldObject, (Object)newObject);
        return saleContractVo;
    }

    @Override
    public SaleContractVo findDetailByCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"code", (Object)code);
        SaleContractEntity entity = (SaleContractEntity)((Object)this.getOne((Wrapper)wrapper));
        SaleContractVo vo = (SaleContractVo)CrmBeanUtil.copy((Object)((Object)entity), SaleContractVo.class);
        if (vo == null) {
            return null;
        }
        ContractTemplateVo templateVo = this.contractTemplateService.findDetailsByCode(vo.getTemplateCode());
        ValidateUtils.validate((Object)templateVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u6a21\u677f");
        vo.setContractTemplateVo(templateVo);
        List tupleVos = templateVo.getTuples();
        if (CollectionUtil.listNotEmpty((List)tupleVos)) {
            JSONObject data = new JSONObject();
            tupleVos.forEach(tuple -> {
                AbstractContractModelListener listenerService = this.contractTupleService.getTupleBean(tuple.getBeanName());
                JSONArray result = listenerService.findByContractCode(code, tuple.getJsonName(), tuple.getIndexCode());
                data.put(tuple.getJsonName(), (Object)result);
            });
            vo.setData(data);
        }
        List<ContractUpdatingFilesVo> filesVos = this.contractUpdatingFilesService.findByContractCode(code);
        vo.setFilesVo(filesVos);
        return vo;
    }

    @Override
    public PageResult<SaleContractVo> findContractPageByConditions(SaleContractVo saleContractVo) {
        Page page = new Page((long)saleContractVo.getPageNum().intValue(), (long)saleContractVo.getPageSize().intValue());
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(StringUtils.isNotEmpty((String)saleContractVo.getCode()), (Object)"code", (Object)saleContractVo.getCode())).eq(StringUtils.isNotEmpty((String)saleContractVo.getContractType()), (Object)"contract_type", (Object)saleContractVo.getContractType())).like(StringUtils.isNotEmpty((String)saleContractVo.getCusCode()), (Object)"cus_code", (Object)saleContractVo.getCusCode())).like(StringUtils.isNotEmpty((String)saleContractVo.getCusName()), (Object)"cus_name", (Object)saleContractVo.getCusName())).like(StringUtils.isNotEmpty((String)saleContractVo.getChannelCode()), (Object)"channel_code", (Object)saleContractVo.getChannelCode())).like(StringUtils.isNotEmpty((String)saleContractVo.getChannelName()), (Object)"channel_name", (Object)saleContractVo.getChannelName())).eq(saleContractVo.getSignState() != null, (Object)"sign_state", (Object)saleContractVo.getSignState())).orderByDesc((Object)"create_date")).orderByDesc((Object)"create_date_second");
        List<SaleContractVo> pageList = this.saleContractMapper.findContractPageByConditions((Page<SaleContractVo>)page, (QueryWrapper<SaleContractVo>)wrapper);
        return PageResult.builder().data(pageList).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            return;
        }
        UpdateWrapper wrapper = (UpdateWrapper)((UpdateWrapper)Wrappers.update().set((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode())).in((Object)"id", ids);
        this.update((Wrapper)wrapper);
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            return;
        }
        UpdateWrapper wrapper = (UpdateWrapper)((UpdateWrapper)Wrappers.update().set((Object)"enable_status", (Object)CrmEnableStatusEnum.DISABLE.getCode())).in((Object)"id", ids);
        this.update((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public SaleContractVo sign(SaleContractVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u5408\u540c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        SaleContractVo dbVo = this.findDetailByCode(vo.getCode());
        ValidateUtils.validate((Object)dbVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u5408\u540c\u8bb0\u5f55");
        ValidateUtils.isTrue((!YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(dbVo.getSignState()) ? 1 : 0) != 0, (String)"\u8be5\u5408\u540c\u5df2\u7b7e\u7ea6\uff0c\u8bf7\u4e0d\u8981\u91cd\u65b0\u64cd\u4f5c", (Object[])new Object[0]);
        dbVo.setSignState(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        boolean signResult = this.updateById(CrmBeanUtil.copy((Object)dbVo, SaleContractEntity.class));
        ValidateUtils.isTrue((boolean)signResult, (String)"\u7b7e\u7ea6\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u540e\u91cd\u8bd5", (Object[])new Object[0]);
        return dbVo;
    }
}

