/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.promotion.entity.PromotionPolicyScopeEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyScopeMapper;
import com.biz.crm.promotion.service.npromotion.PromotionScopeService;
import com.biz.crm.promotion.service.npromotion.vo.PromotionScopeVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonFieldUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"promotionScopeServiceExtend"})
public class PromotionScopeServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<PromotionPolicyScopeMapper, PromotionPolicyScopeEntity>
implements PromotionScopeService {
    @Resource
    private PromotionPolicyScopeMapper promotionPolicyScopeMapper;

    @Override
    @Transactional
    public List<PromotionScopeVo> saveBatch(List<PromotionScopeVo> scopeVos, String promotionPolicyCode) {
        if (CollectionUtil.listEmpty(scopeVos)) {
            return Lists.newArrayList();
        }
        List<PromotionScopeVo> dbVos = this.findByPromotionCode(promotionPolicyCode);
        List<PromotionScopeVo> createVos = scopeVos.stream().filter(v -> StringUtils.isEmpty((String)v.getId())).collect(Collectors.toList());
        createVos.forEach(v -> v.setScopeCode(CodeUtil.generateCode()));
        List createEntities = CrmBeanUtil.copyList(createVos, PromotionPolicyScopeEntity.class);
        boolean createFlag = this.saveBatch(createEntities);
        ValidateUtils.isTrue((boolean)createFlag, (String)"\u6279\u91cf\u65b0\u589e\u4fc3\u9500\u8303\u56f4\u5931\u8d25", (Object[])new Object[0]);
        scopeVos.removeAll(createVos);
        scopeVos.addAll(CrmBeanUtil.copyList((List)createEntities, PromotionScopeVo.class));
        List deleteIds = CommonFieldUtil.difference(dbVos, createVos, (String[])new String[]{"id"});
        boolean deleteFlag = this.removeByIds(deleteIds);
        ValidateUtils.isTrue((boolean)deleteFlag, (String)"\u6279\u91cf\u5220\u9664\u4fc3\u9500\u8303\u56f4\u5931\u8d25", (Object[])new Object[0]);
        List updateVos = scopeVos.stream().filter(v -> StringUtils.isNotEmpty((String)v.getId()) && !deleteIds.contains(v.getId())).collect(Collectors.toList());
        this.updateBatchById(CrmBeanUtil.copyList(updateVos, PromotionPolicyScopeEntity.class));
        return scopeVos;
    }

    @Override
    public List<PromotionScopeVo> findByPromotionCode(String promotionPolicyCode) {
        if (StringUtils.isEmpty((String)promotionPolicyCode)) {
            return Lists.newArrayList();
        }
        List entities = this.promotionPolicyScopeMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(PromotionPolicyScopeEntity::getPromotionPolicyCode, (Object)promotionPolicyCode));
        return CrmBeanUtil.copyList((List)entities, PromotionScopeVo.class);
    }
}

