/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.dms.ScopeTypeDynamicEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionProductVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionRuleVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionScopeSourceVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionScopeVo;
import com.biz.crm.nebular.dms.promotion.PromotionInfoRespVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScopeVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.promotion.entity.PromotionPolicyEntity;
import com.biz.crm.promotion.entity.PromotionPolicyScopeEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyMapper;
import com.biz.crm.promotion.mapper.PromotionPolicyScopeMapper;
import com.biz.crm.promotion.service.PromotionPolicyTemplateService;
import com.biz.crm.promotion.service.npromotion.PromotionProductService;
import com.biz.crm.promotion.service.npromotion.PromotionRuleService;
import com.biz.crm.promotion.service.npromotion.PromotionScopeService;
import com.biz.crm.promotion.service.npromotion.PromotionService;
import com.biz.crm.promotion.service.npromotion.validators.PromotionValidator;
import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"promotionServiceExtend"})
public class PromotionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<PromotionPolicyMapper, PromotionPolicyEntity>
implements PromotionService {
    @Resource
    private PromotionPolicyMapper promotionPolicyMapper;
    @Resource
    private PromotionRuleService promotionRuleService;
    @Resource
    private PromotionScopeService promotionScopeService;
    @Resource
    private PromotionProductService promotionProductService;
    @Resource
    private PromotionValidator promotionValidator;
    @Resource
    private PromotionPolicyTemplateService promotionPolicyTemplateService;
    @Resource
    private PromotionPolicyScopeMapper policyScopeMapper;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;

    @Override
    @Transactional
    public PromotionEditVo create(PromotionEditVo createVo) {
        this.promotionValidator.validateCreate(createVo);
        createVo.setPromotionPolicyCode(CodeUtil.generateCode());
        if (createVo.getTemplateVo() != null && StringUtils.isNotEmpty((String)createVo.getTemplateVo().getPromotionType())) {
            createVo.setPromotionType(createVo.getTemplateVo().getPromotionType());
        }
        PromotionPolicyEntity entity = (PromotionPolicyEntity)((Object)CrmBeanUtil.copy((Object)createVo, PromotionPolicyEntity.class));
        boolean createFlag = this.save((Object)entity);
        ValidateUtils.isTrue((boolean)createFlag, (String)"\u521b\u5efa\u4fc3\u9500\u653f\u7b56\u5931\u8d25", (Object[])new Object[0]);
        createVo.setId(entity.getId());
        this.saveDetails(createVo);
        return createVo;
    }

    @Override
    @Transactional
    public PromotionEditVo update(PromotionEditVo updateVo) {
        this.promotionValidator.validateUpdate(updateVo);
        PromotionPolicyEntity dbEntity = (PromotionPolicyEntity)((Object)this.getById((Serializable)((Object)updateVo.getId())));
        ValidateUtils.validate((Object)((Object)dbEntity), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165id\u662f\u5426\u6b63\u786e");
        PromotionPolicyEntity entity = (PromotionPolicyEntity)((Object)CrmBeanUtil.copy((Object)updateVo, PromotionPolicyEntity.class));
        boolean updateFlag = this.updateById((Object)entity);
        ValidateUtils.isTrue((boolean)updateFlag, (String)"\u66f4\u65b0\u4fc3\u9500\u653f\u7b56\u5931\u8d25", (Object[])new Object[0]);
        this.saveDetails(updateVo);
        PromotionUtil.deleteCaches(Lists.newArrayList((Object[])new String[]{updateVo.getPromotionPolicyCode()}));
        return updateVo;
    }

    @Override
    public PromotionEditVo findDetailsById(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        PromotionPolicyEntity entity = (PromotionPolicyEntity)((Object)this.getById((Serializable)((Object)id)));
        if (entity == null) {
            return null;
        }
        PromotionEditVo editVo = PromotionUtil.getOneCache(entity.getPromotionPolicyCode(), this);
        return editVo;
    }

    @Override
    public PromotionEditVo findDetailsByCode(String promotionCode) {
        if (StringUtils.isEmpty((String)promotionCode)) {
            return null;
        }
        PromotionPolicyEntity entity = (PromotionPolicyEntity)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(PromotionPolicyEntity::getPromotionPolicyCode, (Object)promotionCode)));
        if (entity == null) {
            return null;
        }
        PromotionEditVo editVo = (PromotionEditVo)CrmBeanUtil.copy((Object)((Object)entity), PromotionEditVo.class);
        List<PromotionScopeVo> scopeVos = this.promotionScopeService.findByPromotionCode(editVo.getPromotionPolicyCode());
        Map<String, List<PromotionScopeVo>> scopeMap = PromotionUtil.formatScopeMap(scopeVos);
        editVo.setScopeMap(scopeMap);
        List<PromotionRuleVo> ruleVos = this.promotionRuleService.findByPromotionCode(editVo.getPromotionPolicyCode());
        Map<String, List<PromotionRuleVo>> ruleMap = PromotionUtil.formatRuleMap(ruleVos);
        editVo.setRuleMap(ruleMap);
        List<PromotionProductVo> productVos = this.promotionProductService.findByPromotionCode(editVo.getPromotionPolicyCode());
        Map<String, List<PromotionProductVo>> productMap = PromotionUtil.formatProductMap(productVos);
        editVo.setProductMap(productMap);
        PromotionPolicyTemplateVo templateVo = this.promotionPolicyTemplateService.findByCode(editVo.getTemplateCode());
        editVo.setTemplateVo(templateVo);
        return editVo;
    }

    @Override
    public List<String> findAvailableByCodes(List<String> promotionCodes) {
        if (CollectionUtil.listEmpty(promotionCodes)) {
            return Lists.newArrayList();
        }
        String date = DateUtil.formatDate();
        date = date + " 00:00:00";
        List entities = this.promotionPolicyMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(PromotionPolicyEntity::getPromotionPolicyCode, promotionCodes)).le(PromotionPolicyEntity::getBeginTime, (Object)date)).ge(PromotionPolicyEntity::getEndTime, (Object)date));
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        return entities.stream().map(PromotionPolicyEntity::getPromotionPolicyCode).collect(Collectors.toList());
    }

    private void saveDetails(PromotionEditVo editVo) {
        List<PromotionScopeVo> scopeVos = PromotionUtil.parseScopeMap(editVo);
        List<PromotionScopeVo> scopeResults = this.promotionScopeService.saveBatch(scopeVos, editVo.getPromotionPolicyCode());
        editVo.setScopeMap(PromotionUtil.formatScopeMap(scopeResults));
        List<PromotionRuleVo> ruleVos = PromotionUtil.parseRuleMap(editVo);
        List<PromotionRuleVo> ruleResults = this.promotionRuleService.saveBatch(ruleVos, editVo.getPromotionPolicyCode());
        editVo.setRuleMap(PromotionUtil.formatRuleMap(ruleResults));
        List<PromotionProductVo> productVos = PromotionUtil.parseProductMap(editVo);
        List<PromotionProductVo> productResults = this.promotionProductService.saveBatch(productVos, editVo.getPromotionPolicyCode());
        editVo.setProductMap(PromotionUtil.formatProductMap(productResults));
    }

    @Override
    public PageResult<PromotionInfoRespVo> findPromotionsByParam(PromotionPolicyQueryVo reqVo) {
        List<PromotionInfoRespVo> list;
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        page.setSearchCount(reqVo.getNeedPageFlag().booleanValue());
        if (reqVo.getQueryEffectiveFlag().booleanValue()) {
            reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        }
        if (CollectionUtils.isNotEmpty(list = this.promotionPolicyMapper.findPromotionsByParam((Page<PromotionInfoRespVo>)page, reqVo)) && reqVo.getQueryScopeFlag().booleanValue()) {
            List codes = list.stream().map(PromotionInfoRespVo::getPromotionPolicyCode).collect(Collectors.toList());
            List policyScopeEntities = this.policyScopeMapper.selectList((Wrapper)Wrappers.lambdaQuery(PromotionPolicyScopeEntity.class).in(PromotionPolicyScopeEntity::getPromotionPolicyCode, codes));
            Map<String, List<PromotionPolicyScopeEntity>> map = policyScopeEntities.stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity::getPromotionPolicyCode));
            list.forEach(o -> {
                List scopeEntities = (List)map.get(o.getPromotionPolicyCode());
                if (CollectionUtils.isNotEmpty((Collection)scopeEntities)) {
                    List promotionPolicyScopeVos = CrmBeanUtil.copyList((List)scopeEntities, PromotionPolicyScopeVo.class);
                    o.setScopeList(promotionPolicyScopeVos);
                } else {
                    o.setScopeList(Collections.EMPTY_LIST);
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<PromotionScopeSourceVo> findScopeSourcePage(PromotionScopeSourceVo param) {
        if (param == null) {
            return PageResult.empty();
        }
        if (Objects.equals(param.getScopeType(), ScopeTypeDynamicEnum.CUS.getCode())) {
            return this.findCusPage(param);
        }
        if (Objects.equals(param.getScopeType(), ScopeTypeDynamicEnum.CUS_ORG.getCode())) {
            return this.findOrgPage(param);
        }
        if (Objects.equals(param.getScopeType(), ScopeTypeDynamicEnum.CUS_CHANNEL.getCode())) {
            return this.findChannelPage(param);
        }
        if (Objects.equals(param.getScopeType(), ScopeTypeDynamicEnum.TERMINAL.getCode())) {
            return this.findTerminalPage(param);
        }
        if (Objects.equals(param.getScopeType(), ScopeTypeDynamicEnum.TERMINAL_ORG.getCode())) {
            return this.findOrgPage(param);
        }
        return PageResult.empty();
    }

    @Override
    public PageResult<PromotionEditVo> findPromotionPageByConditions(PromotionEditVo param) {
        if (param == null) {
            param = new PromotionEditVo();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(StringUtils.isNotEmpty((String)param.getPromotionPolicyCode()), PromotionPolicyEntity::getPromotionPolicyCode, (Object)param.getPromotionPolicyCode())).like(StringUtils.isNotEmpty((String)param.getPromotionPolicyName()), PromotionPolicyEntity::getPromotionPolicyName, (Object)param.getPromotionPolicyName())).orderByDesc(CrmBaseEntity::getCreateDate)).orderByDesc(CrmBaseEntity::getCreateDateSecond);
        Page pageResult = (Page)this.promotionPolicyMapper.selectPage((IPage)new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue()), (Wrapper)wrapper);
        return PageResult.builder().count(Long.valueOf(pageResult.getTotal())).data(CrmBeanUtil.copyList((List)pageResult.getRecords(), PromotionEditVo.class)).build();
    }

    protected PageResult<PromotionScopeSourceVo> findChannelPage(PromotionScopeSourceVo param) {
        return PageResult.empty();
    }

    protected PageResult<PromotionScopeSourceVo> findTerminalPage(PromotionScopeSourceVo param) {
        MdmTerminalVo p = new MdmTerminalVo();
        p.setTerminalCode(param.getScopeCode());
        p.setTerminalName(param.getScopeName());
        p.setPageNum(param.getPageNum());
        p.setPageSize(param.getPageSize());
        PageResult result = (PageResult)this.mdmTerminalFeign.page(p).getResult();
        List list = result.getData() == null ? Lists.newArrayList() : result.getData();
        ArrayList scopes = Lists.newArrayList();
        list.forEach(li -> {
            PromotionScopeSourceVo scope = new PromotionScopeSourceVo();
            scope.setScopeCode(li.getTerminalCode());
            scope.setScopeName(li.getTerminalName());
            scope.setScopeType(param.getScopeType());
            scopes.add(scope);
        });
        return PageResult.builder().count(result.getCount()).data((List)scopes).build();
    }

    protected PageResult<PromotionScopeSourceVo> findOrgPage(PromotionScopeSourceVo param) {
        MdmOrgReqVo p = new MdmOrgReqVo();
        p.setOrgCode(param.getScopeCode());
        p.setOrgName(param.getScopeName());
        p.setPageNum(param.getPageNum());
        p.setPageSize(param.getPageSize());
        PageResult result = (PageResult)this.mdmOrgFeign.pageList(p).getResult();
        List list = result.getData() == null ? Lists.newArrayList() : result.getData();
        ArrayList scopes = Lists.newArrayList();
        list.forEach(li -> {
            PromotionScopeSourceVo scope = new PromotionScopeSourceVo();
            scope.setScopeCode(li.getOrgCode());
            scope.setScopeName(li.getOrgName());
            scope.setScopeType(param.getScopeType());
            scopes.add(scope);
        });
        return PageResult.builder().count(result.getCount()).data((List)scopes).build();
    }

    protected PageResult<PromotionScopeSourceVo> findCusPage(PromotionScopeSourceVo param) {
        MdmCustomerMsgReqVo p = new MdmCustomerMsgReqVo();
        p.setCustomerCode(param.getScopeCode());
        p.setCustomerName(param.getScopeName());
        p.setPageNum(param.getPageNum());
        p.setPageSize(param.getPageSize());
        PageResult result = (PageResult)this.mdmCustomerMsgFeign.list(p).getResult();
        List list = result.getData() == null ? Lists.newArrayList() : result.getData();
        ArrayList scopes = Lists.newArrayList();
        list.forEach(li -> {
            PromotionScopeSourceVo scope = new PromotionScopeSourceVo();
            scope.setScopeCode(li.getCustomerCode());
            scope.setScopeName(li.getCustomerName());
            scope.setScopeType(param.getScopeType());
            scopes.add(scope);
        });
        return PageResult.builder().count(result.getCount()).data((List)scopes).build();
    }
}

