/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyProduct;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyProductEditVo;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.biz.crm.promotion.entity.PromotionPolicyTemplateEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyProductMapper;
import com.biz.crm.promotion.mapper.PromotionPolicyTemplateMapper;
import com.biz.crm.promotion.service.PromotionPolicyProductService;
import com.biz.crm.promotion.service.impl.LoadConfigInfoContext;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional
@ConditionalOnMissingBean(name={"promotionPolicyProductServiceExpandImpl"})
@Service(value="promotionPolicyProductService")
public class PromotionPolicyProductServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<PromotionPolicyProductMapper, PromotionPolicyProductEntity>
implements PromotionPolicyProductService {
    @Resource
    private PromotionPolicyProductMapper promotionPolicyProductMapper;
    @Resource
    private PromotionPolicyTemplateMapper promotionPolicyTemplateMapper;

    @Override
    public void refreshProduct(PromotionPolicyEditReqVo editVo) {
        if (StringUtils.isNotBlank((CharSequence)editVo.getId())) {
            this.doDelByPromotionPolicyIdOrCode(Lists.newArrayList((Object[])new String[]{editVo.getId()}), null);
        }
        List tempEditVos = editVo.takeAllProducts();
        ArrayList editVos = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)tempEditVos)) {
            return;
        }
        PromotionPolicyTemplateEntity templateEntity = (PromotionPolicyTemplateEntity)((Object)this.promotionPolicyTemplateMapper.selectById((Serializable)((Object)editVo.getTemplateId())));
        HashSet keys = Sets.newHashSet();
        for (PromotionPolicyProductEditVo temp : tempEditVos) {
            String key = temp.getPromotionPolicyId() + temp.getProductCode() + temp.getCurrentProduct();
            if (keys.contains(key)) continue;
            if (!PromotionPolicyEunm.PromotionProductTypeEunm.CURRENT_RELATIONAL_GIFT.getCode().equals(templateEntity.getPromotionProduct())) {
                temp.setProductCodeGift(null);
                temp.setProductNameGift(null);
            }
            temp.setId(null);
            temp.setPromotionPolicyCode(editVo.getPromotionPolicyCode());
            temp.setPromotionPolicyId(editVo.getId());
            temp.setPromotionPolicyName(editVo.getPromotionPolicyName());
            editVos.add(temp);
            keys.add(key);
        }
        this.saveBatch(CrmBeanUtil.copyList((List)editVos, PromotionPolicyProductEntity.class));
    }

    @Override
    public void loadListForEditPromotionPolicy(PromotionPolicyEditVo editVo) {
        List<PromotionPolicyProductEntity> y = null;
        List<PromotionPolicyProductEntity> n = null;
        if (StringUtils.isNotBlank((CharSequence)editVo.getId())) {
            QueryWrapper wrapper = Wrappers.query();
            wrapper.in((Object)"promotion_policy_id", new Object[]{editVo.getId()});
            Map<String, List<PromotionPolicyProductEntity>> groupByCurrentProduct = this.promotionPolicyProductMapper.selectList((Wrapper)wrapper).stream().collect(Collectors.groupingBy(PromotionPolicyProductEntity::getCurrentProduct));
            y = groupByCurrentProduct.get(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            n = groupByCurrentProduct.get(CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
        }
        PromotionPolicyProduct promotionPolicyProduct = new PromotionPolicyProduct();
        promotionPolicyProduct.setProductsCurrentY(CrmBeanUtil.copyList(y, PromotionPolicyProductEditVo.class));
        promotionPolicyProduct.setProductsCurrentN(CrmBeanUtil.copyList(n, PromotionPolicyProductEditVo.class));
        editVo.setPromotionPolicyProduct(promotionPolicyProduct);
    }

    @Override
    public void delByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        this.doDelByPromotionPolicyIdOrCode(promotionPolicyId, promotionPolicyCode);
    }

    @Override
    public Set<String> selectPromotionPolicyIdByProductCode(String productCode) {
        if (StringUtils.isBlank((CharSequence)productCode)) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet(this.promotionPolicyProductMapper.selectPromotionPolicyIdByProductCode(productCode));
    }

    @Override
    public List<PromotionPolicyProductEntity> selectPromotionPolicyIdByProductCodes(List<String> productCodes) {
        return this.promotionPolicyProductMapper.selectPromotionPolicyIdByProductCodes(productCodes);
    }

    private void doDelByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        QueryWrapper wrapper = Wrappers.query();
        if (!CollectionUtils.isEmpty(promotionPolicyId)) {
            wrapper.in((Object)"promotion_policy_id", promotionPolicyId);
        } else if (!CollectionUtils.isEmpty(promotionPolicyCode)) {
            wrapper.in((Object)"promotion_policy_code", promotionPolicyCode);
        } else {
            return;
        }
        this.promotionPolicyProductMapper.delete((Wrapper)wrapper);
    }

    @Override
    public void selectGiftByPromotionPolicyId(LoadConfigInfoContext loadConfigInfoContext, String isCurrentProduct) {
        Set<String> promotionPolicyIds = loadConfigInfoContext.getPromotionPolicyIds();
        if (CollectionUtils.isEmpty(promotionPolicyIds) || StringUtils.isBlank((CharSequence)isCurrentProduct)) {
            return;
        }
        List entities = this.promotionPolicyProductMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PromotionPolicyProductEntity.class).eq(PromotionPolicyProductEntity::getCurrentProduct, (Object)isCurrentProduct)).in(PromotionPolicyProductEntity::getPromotionPolicyId, promotionPolicyIds));
        HashMap result = Maps.newHashMap();
        Map<String, List<PromotionPolicyProductEntity>> tempData = entities.stream().collect(Collectors.groupingBy(PromotionPolicyProductEntity::getPromotionPolicyId));
        tempData.forEach((promotionPolicyId, promotionPolicyProductEntities) -> result.put(promotionPolicyId, promotionPolicyProductEntities.stream().collect(Collectors.toMap(PromotionPolicyProductEntity::getProductCode, v -> v, (p, p2) -> p2))));
        if (CommonConstant.GLOBAL.YesOrNo.Y.getItemCode().equals(isCurrentProduct)) {
            loadConfigInfoContext.setCurrentProductY(result);
            Map<String, Map<String, PromotionPolicyProductEntity>> resultAsCurrentProductN = this.resolveCurrentN(tempData);
            loadConfigInfoContext.addCurrentProductCodesN(entities.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getProductCodeGift())).map(PromotionPolicyProductEntity::getProductCodeGift).collect(Collectors.toSet()));
            loadConfigInfoContext.addCurrentProductN(resultAsCurrentProductN);
        }
        if (CommonConstant.GLOBAL.YesOrNo.N.getItemCode().equals(isCurrentProduct)) {
            loadConfigInfoContext.addCurrentProductCodesN(entities.stream().map(PromotionPolicyProductEntity::getProductCode).collect(Collectors.toSet()));
            loadConfigInfoContext.addCurrentProductN(result);
        }
    }

    @Override
    public Map<String, List<PromotionPolicyProductEntity>> findProductsByPromotionIds(ArrayList<String> promotionIds, String isCurrent) {
        if (CollectionUtil.listEmpty(promotionIds)) {
            return Maps.newHashMap();
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq(StringUtils.isNotBlank((CharSequence)isCurrent), (Object)"current_product", (Object)isCurrent)).in((Object)"promotion_policy_id", promotionIds);
        List productEntities = this.promotionPolicyProductMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)productEntities)) {
            return promotionIds.stream().collect(Collectors.toMap(a -> a, a -> Lists.newArrayList()));
        }
        Map<String, List<PromotionPolicyProductEntity>> result = productEntities.stream().collect(Collectors.groupingBy(PromotionPolicyProductEntity::getPromotionPolicyId));
        promotionIds.forEach(id -> {
            if (CollectionUtil.listEmpty((List)((List)result.get(id)))) {
                result.put((String)id, Lists.newArrayList());
            }
        });
        return result;
    }

    private Map<String, Map<String, PromotionPolicyProductEntity>> resolveCurrentN(Map<String, List<PromotionPolicyProductEntity>> tempData) {
        HashMap resultAsCurrentProductN = Maps.newHashMap();
        tempData.forEach((promotionPolicyId, promotionPolicyProductEntities) -> resultAsCurrentProductN.put(promotionPolicyId, promotionPolicyProductEntities.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getProductCodeGift())).collect(Collectors.toMap(PromotionPolicyProductEntity::getProductCodeGift, v -> {
            PromotionPolicyProductEntity gift = (PromotionPolicyProductEntity)((Object)((Object)((Object)CrmBeanUtil.copy((Object)v, PromotionPolicyProductEntity.class))));
            gift.setProductCode(gift.getProductCodeGift());
            gift.setProductName(gift.getProductNameGift());
            return gift;
        }, (p, p2) -> {
            PromotionPolicyProductEntity gift = (PromotionPolicyProductEntity)((Object)((Object)((Object)CrmBeanUtil.copy((Object)p2, PromotionPolicyProductEntity.class))));
            gift.setProductCode(gift.getProductCodeGift());
            gift.setProductName(gift.getProductNameGift());
            return gift;
        }))));
        return resultAsCurrentProductN;
    }
}

