/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.enums;

import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RuleTypeDynamicEnum {
    public static final String PROMOTION_POLICY_RULE_TYPE = "promotion_policy_rule_type";
    public static final RuleTypeDynamicEnum CONDITION = RuleTypeDynamicEnum.initEnum("condition", "\u6761\u4ef6\u89c4\u5219");
    public static final RuleTypeDynamicEnum CALCULATE = RuleTypeDynamicEnum.initEnum("calculate", "\u8ba1\u7b97\u89c4\u5219");
    public static final RuleTypeDynamicEnum LIMITED = RuleTypeDynamicEnum.initEnum("limited", "\u9650\u91cf\u89c4\u5219");
    private String code;
    private String desc;
    private String objectName;

    private static RuleTypeDynamicEnum initEnum(String code, String desc) {
        return new RuleTypeDynamicEnum(code, desc, RuleTypeDynamicEnum.buildObjectName(code));
    }

    public static String buildObjectName(String code) {
        return code.concat("s");
    }

    public static List<RuleTypeDynamicEnum> getRuleTypeEnums() {
        Map dictMap = DictUtil.dictMap((String)PROMOTION_POLICY_RULE_TYPE);
        if (!CollectionUtil.mapNotEmpty((Map)dictMap)) {
            return Lists.newArrayList();
        }
        ArrayList ruleTypeDynamicEnums = Lists.newArrayList();
        dictMap.forEach((k, v) -> {
            RuleTypeDynamicEnum rule = new RuleTypeDynamicEnum((String)k, (String)v, RuleTypeDynamicEnum.buildObjectName(k));
            ruleTypeDynamicEnums.add(rule);
        });
        return ruleTypeDynamicEnums;
    }

    public static RuleTypeDynamicEnum getRuleTypeEnumByCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        String value = DictUtil.dictValue((String)PROMOTION_POLICY_RULE_TYPE, (String)code);
        return new RuleTypeDynamicEnum(code, value, RuleTypeDynamicEnum.buildObjectName(code));
    }

    public static RuleTypeDynamicEnum getRuleTypeEnumByObjectName(String objectName) {
        List<RuleTypeDynamicEnum> ruleTypeDynamicEnums = RuleTypeDynamicEnum.getRuleTypeEnums();
        if (CollectionUtil.listEmpty(ruleTypeDynamicEnums = ruleTypeDynamicEnums.stream().filter(rule -> Objects.equals(rule.getObjectName(), objectName)).collect(Collectors.toList()))) {
            return null;
        }
        return (RuleTypeDynamicEnum)ruleTypeDynamicEnums.stream().findFirst().get();
    }

    public RuleTypeDynamicEnum(String code, String desc, String objectName) {
        this.code = code;
        this.desc = desc;
        this.objectName = objectName;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getObjectName() {
        return this.objectName;
    }
}

