/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.dms.RuleTypeDynamicEnum;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleSelectionVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleVo;
import com.biz.crm.promotion.entity.PromotionPolicyTemplateRuleEntity;
import com.biz.crm.promotion.entity.PromotionRuleEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyRuleMapper;
import com.biz.crm.promotion.mapper.PromotionPolicyTemplateRuleMapper;
import com.biz.crm.promotion.mapper.PromotionRuleMapper;
import com.biz.crm.promotion.service.PromotionPolicyTemplateRuleService;
import com.biz.crm.promotion.service.PromotionRuleService;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.TestRuleParam;
import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional
@ConditionalOnMissingBean(name={"pomotionRuleServiceExpandImpl"})
@Service(value="pomotionRuleService")
public class PromotionRuleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<PromotionRuleMapper, PromotionRuleEntity>
implements PromotionRuleService {
    @Resource
    private PromotionRuleMapper promotionRuleMapper;
    @Resource
    private PromotionPolicyTemplateRuleService promotionPolicyTemplateRuleService;
    @Resource
    private PromotionPolicyTemplateRuleMapper promotionPolicyTemplateRuleMapper;
    @Resource
    private PromotionPolicyRuleMapper promotionPolicyRuleMapper;

    @Override
    public String addOrUpdate(PromotionRuleEditVo vo) {
        PromotionRuleEntity entity;
        this.checkParams(vo);
        if ((RuleTypeDynamicEnum.CONDITION.getCode().equals(vo.getRuleType()) || RuleTypeDynamicEnum.CALCULATE.getCode().equals(vo.getRuleType())) && vo.getTestParam() != null) {
            PromotionUtil.validateLadder(vo.getTestParam().getControlRow());
        }
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"rule_code", (Object)vo.getRuleCode());
            if (this.promotionRuleMapper.selectCount((Wrapper)wrapper) > 0) {
                throw new BusinessException("\u5df2\u5b58\u5728\u7684\u89c4\u5219\u7f16\u7801[" + vo.getRuleCode() + "]\u3002");
            }
            entity = (PromotionRuleEntity)((Object)CrmBeanUtil.copy((Object)vo, PromotionRuleEntity.class));
            entity.setTestParam(JsonPropertyUtil.toJsonString((Object)vo.getTestParam()));
            this.promotionRuleMapper.insert((Object)entity);
            vo.setId(entity.getId());
        } else {
            if (null == this.promotionRuleMapper.selectById((Serializable)((Object)vo.getId()))) {
                throw new BusinessException("\u89c4\u5219\u6570\u636e\u4e0d\u5b58\u5728,ID=[" + vo.getId() + "]");
            }
            entity = new PromotionRuleEntity();
            entity.setLevelNo(vo.getLevelNo());
            entity.setFuncBody(vo.getFuncBody());
            entity.setTestParam(JsonPropertyUtil.toJsonString((Object)vo.getTestParam()));
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"promotion_rule_id", (Object)vo.getId());
            if (this.promotionPolicyRuleMapper.selectCount((Wrapper)wrapper) == 0) {
                entity.setRuleName(vo.getRuleName());
            }
            entity.setId(vo.getId());
            this.promotionRuleMapper.updateById((Object)entity);
        }
        this.doTestFunc((PromotionRuleEntity)((Object)this.promotionRuleMapper.selectById((Serializable)((Object)vo.getId()))));
        PromotionUtil.setRuleOneCache(entity.getRuleCode(), (PromotionRuleEditVo)CrmBeanUtil.copy((Object)((Object)entity), PromotionRuleEditVo.class));
        return vo.getId();
    }

    @Override
    public void del(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"promotion_rule_id", (Object)id);
            this.promotionRuleMapper.deleteById((Serializable)((Object)id));
        }
    }

    @Override
    public List<PromotionRuleVo> getList(PromotionRuleVo vo) {
        List<PromotionRuleEntity> list = this.getListEntity(vo);
        return CrmBeanUtil.copyList(list, PromotionRuleVo.class);
    }

    @Override
    public PromotionRuleEditVo loadEditVoById(String id) {
        ValidateUtils.validate((Object)id, (String)"\u8bf7\u6307\u5b9a\u89c4\u5219ID");
        PromotionRuleEntity entity = (PromotionRuleEntity)((Object)this.promotionRuleMapper.selectById((Serializable)((Object)id)));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u672a\u52a0\u8f7d\u5230\u89c4\u5219\u6570\u636e");
        PromotionRuleEditVo vo = (PromotionRuleEditVo)CrmBeanUtil.copy((Object)((Object)entity), PromotionRuleEditVo.class);
        vo.setTestParam((PromotionRuleEditVo.TestParam)JsonPropertyUtil.toObject((String)entity.getTestParam(), PromotionRuleEditVo.TestParam.class));
        return vo;
    }

    public static void main(String[] args) {
        String json = "{\"bizParam\":{\"productOrderBuy\":[{\"productBuyNo\":\"20\",\"productBuyAmount\":\"1000\",\"unitConvertor\":\"10\"}]},\"controlRow\":{\"text\":\"\u672c\u5355\u4e2d\u672c\u54c1\u6570\u91cf\u8d2d\u4e70\u6ee1\",\"controlKey\":\"control_key\",\"controlType\":\"countAmount\",\"controls\":[{\"key\":\"buyNo\",\"value\":\"10\",\"label\":\"\",\"labelPostfix\":\"\",\"description\":\"\u8bf7\u8f93\u5165\u672c\u54c1\u6570\u91cf\",\"controlType\":\"input\",\"selectOptions\":[]},{\"key\":\"buyUnit\",\"value\":\"baseUnit\",\"label\":\"\",\"labelPostfix\":\"\",\"description\":\"\u8bf7\u9009\u62e9\u5355\u4f4d\",\"controlType\":\"select\",\"selectOptions\":[{\"key\":\"baseUnit\",\"value\":\"\u57fa\u672c\u5355\u4f4d\"},{\"key\":\"saleUnit\",\"value\":\"\u9500\u552e\u5355\u4f4d\"}]},{\"key\":\"giftNo\",\"value\":\"55\",\"label\":\"\uff0c\u51cf\u91d1\u989d\uff08\u5143\uff09\",\"labelPostfix\":\"\",\"description\":\"\u8bf7\u8f93\u5165\u51cf\u514d\u91d1\u989d\",\"controlType\":\"input\",\"selectOptions\":[]}]}}";
        PromotionRuleEditVo.TestParam rel = (PromotionRuleEditVo.TestParam)JsonPropertyUtil.toObject((String)json, PromotionRuleEditVo.TestParam.class);
    }

    private List<PromotionRuleEntity> getListEntity(PromotionRuleVo vo) {
        QueryWrapper wrapper = new QueryWrapper();
        String getPromotionType = vo.getPromotionType();
        String getRuleType = vo.getRuleType();
        if (StringUtils.isNotBlank((CharSequence)getPromotionType)) {
            wrapper.in((Object)"promotion_type", (Collection)Lists.newArrayList((Object[])new String[]{getPromotionType, PromotionRuleVo.PROMOTION_TYPE.def.name()}));
        }
        if (StringUtils.isNotBlank((CharSequence)getRuleType)) {
            wrapper.eq((Object)"rule_type", (Object)getRuleType);
        }
        List list = this.promotionRuleMapper.selectList((Wrapper)wrapper);
        return list;
    }

    @Override
    public PromotionPolicyTemplateEditVo loadTemplateRuleGroupByRuleType(PromotionPolicyTemplateEditVo templateEditVo, boolean allRule) {
        if (null == templateEditVo) {
            return null;
        }
        Map<Object, Object> templateRuleEntityMap = StringUtils.isNotBlank((CharSequence)templateEditVo.getId()) ? this.promotionPolicyTemplateRuleService.getEntitysByTemplateId(templateEditVo.getId()).stream().collect(Collectors.toMap(PromotionPolicyTemplateRuleEntity::getPromotionRuleId, v -> v, (t, t2) -> t2)) : Maps.newHashMap();
        PromotionRuleVo vo = new PromotionRuleVo();
        vo.setPromotionType(templateEditVo.getPromotionType());
        List<PromotionRuleEntity> list = this.getListEntity(vo);
        ArrayList condition = Lists.newArrayList();
        ArrayList limited = Lists.newArrayList();
        ArrayList calculate = Lists.newArrayList();
        for (PromotionRuleEntity entity : list) {
            boolean selected = templateRuleEntityMap.containsKey(entity.getId());
            if (!selected && !allRule) continue;
            PromotionRuleSelectionVo tempVo = (PromotionRuleSelectionVo)CrmBeanUtil.copy((Object)((Object)entity), PromotionRuleSelectionVo.class);
            tempVo.setSelected(Boolean.valueOf(selected));
            if (PromotionRuleVo.RULE_TYPE.calculate.name().equals(tempVo.getRuleType())) {
                calculate.add(tempVo);
                continue;
            }
            if (PromotionRuleVo.RULE_TYPE.condition.name().equals(tempVo.getRuleType())) {
                condition.add(tempVo);
                continue;
            }
            if (!PromotionRuleVo.RULE_TYPE.limited.name().equals(tempVo.getRuleType())) continue;
            limited.add(tempVo);
        }
        templateEditVo.setCalculate((List)calculate);
        templateEditVo.setLimited((List)limited);
        templateEditVo.setCondition((List)condition);
        return templateEditVo;
    }

    @Override
    public List<PromotionRuleEntity> getListByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"id", ids);
        List list = this.promotionRuleMapper.selectList((Wrapper)wrapper);
        return list;
    }

    @Override
    public PromotionRuleEditVo findByRuleCode(String ruleCode) {
        if (StringUtils.isBlank((CharSequence)ruleCode)) {
            return null;
        }
        List entities = this.promotionRuleMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(PromotionRuleEntity::getRuleCode, (Object)ruleCode));
        if (CollectionUtil.listEmpty((List)entities)) {
            return null;
        }
        return (PromotionRuleEditVo)CrmBeanUtil.copy(entities.get(0), PromotionRuleEditVo.class);
    }

    @Override
    public Object testFunc(PromotionRuleEditVo vo) {
        ValidateUtils.validate((Object)vo.getFuncBody(), (String)"\u51fd\u6570\u5b9e\u4f8b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        if (vo.getTestParam() != null && (RuleTypeDynamicEnum.CONDITION.getCode().equals(vo.getRuleType()) || RuleTypeDynamicEnum.CALCULATE.getCode().equals(vo.getRuleType()))) {
            PromotionUtil.validateLadder(vo.getTestParam().getControlRow());
        }
        PromotionRuleEntity entity = (PromotionRuleEntity)((Object)CrmBeanUtil.copy((Object)vo, PromotionRuleEntity.class));
        entity.setTestParam(JsonPropertyUtil.toJsonString((Object)vo.getTestParam()));
        return this.doTestFunc(entity);
    }

    private Object doTestFunc(PromotionRuleEntity entity) {
        RuleFunction ruleFunction;
        if (StringUtils.isBlank((CharSequence)entity.getTestParam())) {
            entity.setTestParam("{}");
        }
        try {
            ruleFunction = (RuleFunction)SpringApplicationContextUtil.getApplicationContext().getBean(entity.getFuncBody(), RuleFunction.class);
        }
        catch (BeansException e) {
            throw new BusinessException("\u89c4\u5219[" + entity.getFuncBody() + "]\u8ba1\u7b97\u5931\u8d25, \u672a\u67e5\u627e\u5230\u8be5\u89c4\u5219\u7684\u8ba1\u7b97\u5b9e\u4f8b", (Throwable)e);
        }
        TestRuleParam ruleParam = new TestRuleParam();
        ruleParam.setRuleCode(entity.getRuleCode());
        PromotionRuleEditVo.TestParam testParam = (PromotionRuleEditVo.TestParam)JsonPropertyUtil.toObject((String)entity.getTestParam(), PromotionRuleEditVo.TestParam.class);
        ruleParam.setTestParam(testParam);
        return ruleFunction.test(ruleParam);
    }

    private void checkParams(PromotionRuleEditVo vo) {
        PromotionRuleEditVo.TestParam testParam;
        ValidateUtils.validate((Object)vo, (String)"\u65e0\u6548\u53c2\u6570\uff0c\u8bf7\u91cd\u8bd5");
        ValidateUtils.validate((Object)vo.getFuncBody(), (String)"\u51fd\u6570\u5b9e\u4f8b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        if (PromotionRuleVo.RULE_TYPE.limited.name().equals(vo.getRuleType())) {
            vo.setPromotionType(PromotionRuleVo.PROMOTION_TYPE.def.name());
        }
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            ValidateUtils.validate((Object)vo.getPromotionType(), (String)"\u4fc3\u9500\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getRuleCode(), (String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getRuleType(), (String)"\u89c4\u5219\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getRuleName(), (String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == (testParam = vo.getTestParam())) {
            return;
        }
        PromotionRuleEditVo.ControlRow controlRow = testParam.getControlRow();
        if (null == controlRow) {
            return;
        }
        if (null == controlRow.getControls()) {
            controlRow.setControls((List)Lists.newArrayList());
            return;
        }
        controlRow.getControls().forEach(v -> {
            if (null == v.getSelectOptions()) {
                v.setSelectOptions((List)Lists.newArrayList());
            }
        });
    }
}

