/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.util;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.dms.RuleTypeDynamicEnum;
import com.biz.crm.eunm.dms.ScopeTypeDynamicEnum;
import com.biz.crm.nebular.dms.npromotion.bo.LadderParseBo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionProductVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionRuleVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionScopeVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.PromotionRuleService;
import com.biz.crm.promotion.service.npromotion.PromotionService;
import com.biz.crm.promotion.service.npromotion.beans.AbstractLadderService;
import com.biz.crm.promotion.util.RedisCacheUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class PromotionUtil {
    private static final Logger log = LoggerFactory.getLogger(PromotionUtil.class);
    public static final String PRODUCT_CURRENTS = "currentProducts";
    public static final String PRODUCT_GIFTS = "giftProducts";
    protected static final String PROMOTION_REDIS_PATH_BASE = "crm:dms:promotion:promotion:";
    protected static final String PROMOTION_RULE_REDIS_PATH_BASE = "crm:dms:promotion:rule:";
    public static ApplicationContext applicationContext;

    public static String formatProductObjectName(String productType) {
        if (Objects.equals(productType, CommonConstant.GLOBAL.YesOrNo.Y.getItemCode())) {
            return PRODUCT_CURRENTS;
        }
        return PRODUCT_GIFTS;
    }

    public static List<PromotionScopeVo> parseScopeMap(PromotionEditVo promotionEditVo) {
        if (Objects.isNull(promotionEditVo) || CollectionUtil.mapEmpty((Map)promotionEditVo.getScopeMap())) {
            return Lists.newArrayList();
        }
        Map scopeMap = promotionEditVo.getScopeMap();
        ArrayList scopeVos = Lists.newArrayList();
        scopeMap.forEach((k, v) -> {
            ScopeTypeDynamicEnum scopeTypeDynamicEnum = ScopeTypeDynamicEnum.getScopeTypeEnumsByObjectName((String)k);
            ValidateUtils.validate((Object)scopeTypeDynamicEnum, (String)"\u6839\u636e\u4fc3\u9500\u8303\u56f4\u53c2\u6570\u540d\u79f0\u3010%s\u3011\u6ca1\u6709\u83b7\u53d6\u5230\u5b57\u5178\u7f16\u7801\uff0c\u8bf7\u786e\u8ba4\u53c2\u6570\u662f\u5426\u6b63\u786e\u4f20\u5165", (Object[])new Object[]{k});
            ValidateUtils.isTrue((Objects.equals(scopeTypeDynamicEnum.getContainName(), k) || Objects.equals(scopeTypeDynamicEnum.getUnContainName(), k) ? 1 : 0) != 0, (String)"\u4fc3\u9500\u8303\u56f4\u53c2\u6570\u4f20\u5165\u9519\u8bef\uff0c\u6ca1\u6709\u5339\u914d\u5230\u53c2\u6570\u540d\uff1a[%s]\uff0c\u6b63\u786e\u7684\u53c2\u6570\u540d\u5e94\u8be5\u662fscope + \u5b57\u5178\u7f16\u7801 + Y|N", (Object[])new Object[]{k});
            if (CollectionUtil.listNotEmpty((List)v)) {
                v.forEach(scope -> {
                    scope.setContainable(k.substring(k.length() - 1));
                    scope.setScopeType(scopeTypeDynamicEnum.getCode());
                    scope.setPromotionPolicyId(promotionEditVo.getId());
                    scope.setPromotionPolicyCode(promotionEditVo.getPromotionPolicyCode());
                    scope.setPromotionPolicyName(promotionEditVo.getPromotionPolicyName());
                    scopeVos.add(scope);
                });
            }
        });
        return scopeVos;
    }

    public static List<PromotionRuleVo> parseRuleMap(PromotionEditVo promotionEditVo) {
        if (Objects.isNull(promotionEditVo) || CollectionUtil.mapEmpty((Map)promotionEditVo.getRuleMap())) {
            return Lists.newArrayList();
        }
        Map ruleMap = promotionEditVo.getRuleMap();
        ArrayList ruleVos = Lists.newArrayList();
        ruleMap.forEach((k, v) -> {
            RuleTypeDynamicEnum ruleTypeDynamicEnum = RuleTypeDynamicEnum.getRuleTypeEnumByObjectName((String)k);
            ValidateUtils.validate((Object)ruleTypeDynamicEnum, (String)"\u6839\u636e\u4fc3\u9500\u89c4\u5219\u53c2\u6570\u540d\u79f0\u3010%s\u3011\u6ca1\u6709\u83b7\u53d6\u5230\u5b57\u5178\u7f16\u7801\uff0c\u8bf7\u786e\u8ba4\u53c2\u6570\u662f\u5426\u6b63\u786e\u4f20\u5165", (Object[])new Object[]{k});
            ValidateUtils.isTrue((boolean)Objects.equals(ruleTypeDynamicEnum.getObjectName(), k), (String)"\u4fc3\u9500\u89c4\u5219\u53c2\u6570\u4f20\u5165\u9519\u8bef\uff0c\u6ca1\u6709\u5339\u914d\u5230\u53c2\u6570\u540d\uff1a[%s]\uff0c\u6b63\u786e\u7684\u53c2\u6570\u540d\u5e94\u8be5\u662f \u5b57\u5178\u7f16\u7801 + s", (Object[])new Object[]{k});
            if (CollectionUtil.listNotEmpty((List)v)) {
                v.forEach(rule -> {
                    rule.setRuleType(ruleTypeDynamicEnum.getCode());
                    rule.setPromotionPolicyId(promotionEditVo.getId());
                    rule.setPromotionPolicyCode(promotionEditVo.getPromotionPolicyCode());
                    rule.setPromotionPolicyTemplateId(promotionEditVo.getTemplateId());
                    rule.setPromotionPolicyTemplateCode(promotionEditVo.getTemplateCode());
                    ruleVos.add(rule);
                });
            }
        });
        return ruleVos;
    }

    public static List<PromotionProductVo> parseProductMap(PromotionEditVo promotionEditVo) {
        if (Objects.isNull(promotionEditVo) || CollectionUtil.mapEmpty((Map)promotionEditVo.getProductMap())) {
            return Lists.newArrayList();
        }
        Map productMap = promotionEditVo.getProductMap();
        ArrayList productVos = Lists.newArrayList();
        productMap.forEach((k, v) -> {
            if (CollectionUtil.listEmpty((List)v)) {
                return;
            }
            v.forEach(product -> {
                product.setPromotionPolicyId(promotionEditVo.getId());
                product.setPromotionPolicyCode(promotionEditVo.getPromotionPolicyCode());
                product.setPromotionPolicyName(promotionEditVo.getPromotionPolicyName());
                if (Objects.equals(PRODUCT_CURRENTS, k)) {
                    product.setCurrentProduct(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
                    productVos.add(product);
                } else if (Objects.equals(PRODUCT_GIFTS, k)) {
                    product.setCurrentProduct(CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
                    productVos.add(product);
                }
            });
        });
        return productVos;
    }

    public static Map<String, List<PromotionScopeVo>> formatScopeMap(List<PromotionScopeVo> scopeVos) {
        if (CollectionUtil.listEmpty(scopeVos)) {
            return Maps.newHashMap();
        }
        Map<String, List<PromotionScopeVo>> scopeMap = scopeVos.stream().collect(Collectors.groupingBy(scope -> ScopeTypeDynamicEnum.buildObjectName((String)scope.getScopeType(), (String)scope.getContainable())));
        if (CollectionUtil.mapEmpty(scopeMap)) {
            return Maps.newHashMap();
        }
        return scopeMap;
    }

    public static Map<String, List<PromotionRuleVo>> formatRuleMap(List<PromotionRuleVo> ruleVos) {
        if (CollectionUtil.listEmpty(ruleVos)) {
            return Maps.newHashMap();
        }
        Map<String, List<PromotionRuleVo>> ruleMap = ruleVos.stream().collect(Collectors.groupingBy(rule -> RuleTypeDynamicEnum.buildObjectName((String)rule.getRuleType())));
        if (CollectionUtil.mapEmpty(ruleMap)) {
            return Maps.newHashMap();
        }
        return ruleMap;
    }

    public static Map<String, List<PromotionProductVo>> formatProductMap(List<PromotionProductVo> productVos) {
        if (CollectionUtil.listEmpty(productVos)) {
            return Maps.newHashMap();
        }
        Map<String, List<PromotionProductVo>> productMap = productVos.stream().collect(Collectors.groupingBy(product -> PromotionUtil.formatProductObjectName(product.getCurrentProduct())));
        if (CollectionUtil.mapEmpty(productMap)) {
            return Maps.newHashMap();
        }
        return productMap;
    }

    public static PromotionEditVo getOneCache(String promotionCode, PromotionService promotionService) {
        if (StringUtils.isEmpty((String)promotionCode)) {
            return null;
        }
        PromotionEditVo vo = (PromotionEditVo)RedisCacheUtil.get(PromotionUtil.getKey(promotionCode));
        if (Objects.isNull(vo)) {
            vo = promotionService.findDetailsByCode(promotionCode);
            PromotionUtil.setOneCache(promotionCode, vo);
        }
        return vo;
    }

    public static List<PromotionEditVo> getCacheList(List<String> promotionCodes, PromotionService promotionService) {
        if (CollectionUtil.listEmpty(promotionCodes)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        promotionCodes.forEach(code -> {
            PromotionEditVo oneCache = PromotionUtil.getOneCache(code, promotionService);
            if (oneCache == null) {
                return;
            }
            list.add(oneCache);
        });
        return list;
    }

    public static void setOneCache(String promotionCode, PromotionEditVo vo) {
        if (StringUtils.isEmpty((String)promotionCode) || Objects.isNull(vo)) {
            return;
        }
        RedisCacheUtil.setByDays(PromotionUtil.getKey(promotionCode), vo);
    }

    public static void deleteCaches(List<String> promotionCodes) {
        if (CollectionUtil.listEmpty(promotionCodes)) {
            return;
        }
        ArrayList keys = Lists.newArrayList();
        promotionCodes.forEach(code -> keys.add(PromotionUtil.getKey(code)));
        RedisCacheUtil.delete(keys);
    }

    public static void setRuleOneCache(String ruleCode, PromotionRuleEditVo ruleVo) {
        if (StringUtils.isEmpty((String)ruleCode)) {
            return;
        }
        RedisCacheUtil.setByDays(PromotionUtil.getRuleKey(ruleCode), ruleVo);
    }

    public static PromotionRuleEditVo getRuleOneCache(String ruleCode, PromotionRuleService service) {
        if (StringUtils.isEmpty((String)ruleCode)) {
            return null;
        }
        PromotionRuleEditVo ruleVo = (PromotionRuleEditVo)RedisCacheUtil.get(PromotionUtil.getRuleKey(ruleCode));
        if (ruleVo == null) {
            ruleVo = service.findByRuleCode(ruleCode);
            PromotionUtil.setRuleOneCache(ruleCode, ruleVo);
        }
        return ruleVo;
    }

    public static <T> T getBean(String name, Class<T> cls) {
        Object bean;
        try {
            bean = applicationContext.getBean(name, cls);
        }
        catch (Exception e) {
            bean = null;
            log.error("\u6839\u636e\u540d\u79f0\u548c\u7c7b\u578b\u83b7\u53d6ioc\u5b9e\u4f8b\u5931\u8d25", (Throwable)e);
        }
        return (T)bean;
    }

    public static <T> T getBean(Class<T> cls) {
        Object bean;
        try {
            bean = applicationContext.getAutowireCapableBeanFactory().getBean(cls);
        }
        catch (Exception e) {
            bean = null;
            log.error("\u6839\u636e\u7c7b\u578b\u4eceioc\u4e2d\u83b7\u53d6\u751f\u6548\u7684\u5b9e\u4f8b\u5931\u8d25", (Throwable)e);
        }
        return (T)bean;
    }

    public static List<PromotionRuleEditVo.ControlRow> parseLadderArray(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return Lists.newArrayList();
        }
        return JSONArray.parseArray((String)text, PromotionRuleEditVo.ControlRow.class);
    }

    private static String getKey(String key) {
        if (StringUtils.isEmpty((String)key)) {
            key = "none";
        }
        return PROMOTION_REDIS_PATH_BASE.concat(key);
    }

    private static String getRuleKey(String key) {
        if (StringUtils.isEmpty((String)key)) {
            key = "none";
        }
        return PROMOTION_RULE_REDIS_PATH_BASE.concat(key);
    }

    private static String getGiftKey(String key) {
        if (StringUtils.isEmpty((String)key)) {
            key = "none";
        }
        return "crm:dms:promotion:gift:".concat(key);
    }

    public static BigDecimal getGift(String promotionCode) {
        if (StringUtils.isEmpty((String)promotionCode)) {
            return BigDecimal.ZERO;
        }
        BigDecimal s = (BigDecimal)RedisCacheUtil.get(PromotionUtil.getGiftKey(promotionCode));
        if (s == null) {
            return BigDecimal.ZERO;
        }
        return s;
    }

    public static void validateLadder(String text) {
        List<PromotionRuleEditVo.ControlRow> controlRows = PromotionUtil.parseLadderArray(text);
        controlRows.forEach(controlRow -> PromotionUtil.validateLadder(controlRow));
    }

    public static void validateLadder(PromotionRuleEditVo.ControlRow controlRow) {
        LadderParseBo ladderParseBo = PromotionUtil.parseLadderByType(controlRow.getControls(), controlRow.getControlType());
        ValidateUtils.validate((Object)ladderParseBo, (String)"\u63a7\u4ef6\u683c\u5f0f\u4e0e\u7c7b\u578b\u4e0d\u5339\u914d");
    }

    public static LadderParseBo parseLadderByType(List<PromotionRuleEditVo.KeyValParamControl> controls, String type) {
        try {
            AbstractLadderService ladderService = PromotionUtil.getBean(AbstractLadderService.class);
            return ladderService.parseLadderByType(controls, type);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("\u63a7\u4ef6\u683c\u5f0f\u4e0e\u7c7b\u578b\u4e0d\u5339\u914d", (Throwable)e);
        }
    }

    public static BigDecimal parseBigDecimalFromObj(Object value, Class cls) {
        if (value == null) {
            return null;
        }
        return new BigDecimal((String)value);
    }

    public static String parseStringFromObj(Object value, Class cls) {
        if (value == null) {
            return null;
        }
        return (String)value;
    }
}

