/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.impl;

import com.biz.crm.eunm.dms.RuleTypeDynamicEnum;
import com.biz.crm.nebular.dms.npromotion.bo.CalculateParamBo;
import com.biz.crm.nebular.dms.npromotion.bo.CalculateResultBo;
import com.biz.crm.nebular.dms.npromotion.bo.LimitedParamBo;
import com.biz.crm.nebular.dms.npromotion.bo.LimitedResultBo;
import com.biz.crm.nebular.dms.npromotion.vo.CalculateHitResultVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionAvailableResp;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionRuleVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.enums.AccountTypeDynamicEnum;
import com.biz.crm.promotion.service.PromotionRuleService;
import com.biz.crm.promotion.service.npromotion.PromotionComputeService;
import com.biz.crm.promotion.service.npromotion.PromotionService;
import com.biz.crm.promotion.service.npromotion.beans.AbstractCalculateComputer;
import com.biz.crm.promotion.service.npromotion.beans.AbstractLimitedComputer;
import com.biz.crm.promotion.service.npromotion.beans.filters.AbstractCommonFilter;
import com.biz.crm.promotion.service.npromotion.beans.filters.AbstractMoqFilter;
import com.biz.crm.promotion.service.npromotion.beans.filters.AbstractProductFilter;
import com.biz.crm.promotion.service.npromotion.beans.filters.AbstractScopeFilter;
import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"promotionComputeServiceExtendImpl"})
public class PromotionComputeServiceImpl
implements PromotionComputeService {
    @Resource
    private PromotionService promotionService;
    @Resource
    private AbstractProductFilter productFilter;
    @Resource
    private AbstractMoqFilter moqFilter;
    @Autowired(required=false)
    private Map<String, AbstractCommonFilter> commonFilterMap;

    @Override
    public List<PromotionAvailableResp> findAvailablePromotionsByAccount(PromotionQueryReq param) {
        AccountTypeDynamicEnum accountTypeDynamicEnum;
        if (param == null || StringUtils.isEmpty((String)param.getAccountCode())) {
            return Lists.newArrayList();
        }
        if (StringUtils.isEmpty((String)param.getAccountType())) {
            param.setAccountType(AccountTypeDynamicEnum.CUSTOMER.getCode());
        }
        if ((accountTypeDynamicEnum = AccountTypeDynamicEnum.getAccountTypeEnumsByCode(param.getAccountType())) == null || accountTypeDynamicEnum.getFilerBeanCls() == null) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        AbstractScopeFilter filter = PromotionUtil.getBean(AbstractScopeFilter.class);
        if (filter == null) {
            return Lists.newArrayList();
        }
        List<String> promotionCodes = filter.apply(param);
        if (CollectionUtil.listEmpty(promotionCodes)) {
            return Lists.newArrayList();
        }
        Map<String, List<String>> productPromotionsMap = this.productFilter.apply(param);
        productPromotionsMap.forEach((productCode, promotionCodeList) -> promotionCodeList.retainAll(promotionCodes));
        productPromotionsMap.forEach((k, v) -> {
            PromotionAvailableResp promotionHitResp = new PromotionAvailableResp();
            promotionHitResp.setProductCode(k);
            List<PromotionEditVo> promotionEditVos = PromotionUtil.getCacheList(v, this.promotionService);
            promotionHitResp.setPromotions(promotionEditVos);
            result.add(promotionHitResp);
        });
        result.forEach(rel -> rel.setPromotions(this.commonFilter(rel.getPromotions(), param)));
        return result;
    }

    @Override
    public List<PromotionEditVo> findHitPromotionsByPromotionCodes(PromotionQueryReq param) {
        if (param == null || CollectionUtil.listEmpty((List)param.getSaleProductVos()) || StringUtils.isEmpty((String)param.getAccountCode()) || StringUtils.isEmpty((String)param.getAccountType())) {
            return Lists.newArrayList();
        }
        List<PromotionAvailableResp> availableResult = this.findAvailablePromotionsByAccount(param);
        ArrayList availableList = Lists.newArrayList();
        availableResult.forEach(hitResp -> availableList.addAll(hitResp.getPromotions()));
        List<Object> availableFilterList = availableList;
        if (CollectionUtil.listNotEmpty((List)param.getPromotionCodes())) {
            availableFilterList = availableList.stream().filter(promotion -> param.getPromotionCodes().contains(promotion.getPromotionPolicyCode())).collect(Collectors.toList());
        }
        Map<String, PromotionEditVo> promotionEditVoMap = availableFilterList.stream().collect(Collectors.toMap(PromotionEditVo::getPromotionPolicyCode, a -> a, (a, b) -> a));
        List<PromotionEditVo> result = promotionEditVoMap.values().stream().collect(Collectors.toList());
        for (PromotionEditVo promotionEditVo : result) {
            List calculateRules = (List)promotionEditVo.getRuleMap().get(RuleTypeDynamicEnum.CALCULATE.getObjectName());
            List conditionRules = (List)promotionEditVo.getRuleMap().get(RuleTypeDynamicEnum.CONDITION.getObjectName());
            String matchMsg = new String();
            boolean matchState = true;
            String moqMatchMsg = this.moqFilter.moqApply(promotionEditVo, param.getSaleProductVos());
            if (!Objects.equals("OK", moqMatchMsg)) {
                promotionEditVo.setMatchState(false);
                matchMsg = String.join((CharSequence)";", matchMsg, moqMatchMsg);
                matchState = false;
            }
            if (CollectionUtil.listEmpty((List)conditionRules)) {
                promotionEditVo.setMatchState(false);
                matchMsg = String.join((CharSequence)";", matchMsg, "\u6ca1\u6709\u5230\u6709\u6548\u7684\u6761\u4ef6\u89c4\u5219");
                matchState = false;
            }
            if (CollectionUtil.listEmpty((List)calculateRules)) {
                promotionEditVo.setMatchState(false);
                matchMsg = String.join((CharSequence)";", matchMsg, "\u6ca1\u6709\u5230\u6709\u6548\u7684\u8ba1\u7b97\u89c4\u5219");
                matchState = false;
            }
            if (!matchState) {
                promotionEditVo.setMatchMsg(matchMsg);
                continue;
            }
            CalculateParamBo calculateParam = new CalculateParamBo();
            PromotionRuleVo calculateRule = (PromotionRuleVo)calculateRules.get(0);
            PromotionRuleVo conditionRule = (PromotionRuleVo)conditionRules.get(0);
            PromotionRuleEditVo calculateRuleEditVo = PromotionUtil.getRuleOneCache(calculateRule.getRuleCode(), PromotionUtil.getBean(PromotionRuleService.class));
            PromotionRuleEditVo conditionRuleEditVo = PromotionUtil.getRuleOneCache(conditionRule.getRuleCode(), PromotionUtil.getBean(PromotionRuleService.class));
            AbstractCalculateComputer calculateComputer = PromotionUtil.getBean(calculateRuleEditVo.getFuncBody(), AbstractCalculateComputer.class);
            CalculateResultBo calculateResult = null;
            if (calculateComputer != null) {
                calculateParam.setConditionRuleFunctionBeanName(conditionRuleEditVo.getFuncBody());
                calculateParam.setLadderList(PromotionUtil.parseLadderArray(conditionRule.getParams()));
                calculateParam.setPrices((Map)Maps.newHashMap());
                calculateParam.setSaleProductVos(param.getSaleProductVos());
                calculateParam.setVariable(promotionEditVo.getUsedQtyUpper() == null ? new BigDecimal(Integer.MAX_VALUE) : promotionEditVo.getUsedQtyUpper());
                calculateParam.setPromotionCode(promotionEditVo.getPromotionPolicyCode());
                calculateParam.setCurrentProductVos((List)promotionEditVo.getProductMap().get("currentProducts"));
                calculateResult = calculateComputer.calculateApply(calculateParam);
                if (calculateResult != null) {
                    matchMsg = String.join((CharSequence)";", matchMsg, calculateResult.getMatchMsg());
                    matchState = calculateResult.isMatchState();
                } else {
                    matchState = false;
                    matchMsg = "\u8ba1\u7b97\u89c4\u5219\u6267\u884c\u5931\u8d25";
                }
            } else {
                matchState = false;
                matchMsg = "\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u8ba1\u7b97\u903b\u8f91(\u76f8\u5e94\u8ba1\u7b97\u89c4\u5219\u51fd\u6570\u914d\u7f6e\u4e0d\u6b63\u786e)";
            }
            List limitedRules = (List)promotionEditVo.getRuleMap().get(RuleTypeDynamicEnum.LIMITED.getObjectName());
            if (!CollectionUtil.listEmpty((List)limitedRules) && matchState) {
                ArrayList limitedResultBos = Lists.newArrayList();
                for (PromotionRuleVo limited : limitedRules) {
                    PromotionRuleEditVo limitedRuleEditVo = PromotionUtil.getRuleOneCache(limited.getRuleCode(), PromotionUtil.getBean(PromotionRuleService.class));
                    AbstractLimitedComputer limitedComputer = PromotionUtil.getBean(limitedRuleEditVo.getFuncBody(), AbstractLimitedComputer.class);
                    if (limitedComputer == null || calculateResult == null) continue;
                    LimitedParamBo paramBo = new LimitedParamBo();
                    paramBo.setGiftValue(calculateResult.getValue());
                    paramBo.setPromotionCode(promotionEditVo.getPromotionPolicyCode());
                    paramBo.setLadder(limited.getControlRows());
                    paramBo.setAccountCode(param.getAccountCode());
                    LimitedResultBo limitedResultBo = limitedComputer.limitedApply(paramBo);
                    matchState = limitedResultBo.isValue();
                    matchMsg = String.join((CharSequence)";", matchMsg, limitedResultBo.getMatchMsg());
                    limitedResultBos.add(limitedResultBo);
                }
                promotionEditVo.setLimitedResultBos((List)limitedResultBos);
            }
            if (matchMsg.startsWith(";")) {
                matchMsg = matchMsg.substring(1);
            }
            promotionEditVo.setMatchState(matchState);
            promotionEditVo.setMatchMsg(matchMsg);
            promotionEditVo.setCalculateHitResultVo((CalculateHitResultVo)CrmBeanUtil.copy(calculateResult, CalculateHitResultVo.class));
        }
        return result;
    }

    @Override
    public Map<String, PromotionEditVo> findHitPromotionMapByPromotionCodes(List<PromotionQueryReq> params) {
        if (CollectionUtil.listEmpty(params)) {
            return Maps.newHashMap();
        }
        params.forEach(p -> ValidateUtils.isTrue((p.getPromotionCodes() != null && p.getPromotionCodes().size() == 1 ? 1 : 0) != 0, (String)"\u6bcf\u6761\u53c2\u6570\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u4fc3\u9500\u7f16\u7801", (Object[])new Object[0]));
        HashMap promotionEditVoMap = Maps.newHashMap();
        params.forEach(p -> {
            List<PromotionEditVo> promotionEditVos = this.findHitPromotionsByPromotionCodes((PromotionQueryReq)p);
            if (CollectionUtil.listEmpty(promotionEditVos)) {
                promotionEditVoMap.put(p.getPromotionCodes().get(0), null);
            } else {
                promotionEditVoMap.put(p.getPromotionCodes().get(0), promotionEditVos.get(0));
            }
        });
        return promotionEditVoMap;
    }

    protected List<PromotionEditVo> commonFilter(List<PromotionEditVo> promotionEditVos, PromotionQueryReq queryReq) {
        if (CollectionUtil.mapEmpty(this.commonFilterMap)) {
            return promotionEditVos;
        }
        Set<String> keySet = this.commonFilterMap.keySet();
        List keyList = keySet.stream().sorted((o1, o2) -> {
            String reg = "^\\d+$";
            Pattern pattern = Pattern.compile(reg);
            Matcher matcher = pattern.matcher((CharSequence)o1);
            Matcher matcher2 = pattern.matcher((CharSequence)o2);
            int c1 = matcher.find() ? Integer.parseInt(matcher.group()) : Integer.MAX_VALUE;
            int c2 = matcher2.find() ? Integer.parseInt(matcher2.group()) : Integer.MAX_VALUE;
            return c2 > c1 ? 1 : -1;
        }).collect(Collectors.toList());
        for (String k : keyList) {
            promotionEditVos = this.commonFilterMap.get(k).filter(promotionEditVos, queryReq);
        }
        return promotionEditVos;
    }

    @Override
    public List<PromotionEditVo> findNoProductPromotionsByAccount(PromotionQueryReq param) {
        throw new RuntimeException("\u529f\u80fd\u6682\u672a\u63d0\u4f9b");
    }

    @Override
    public Map<String, Boolean> findAvailablePromotionMapByCus(PromotionQueryReq param) {
        AccountTypeDynamicEnum accountTypeDynamicEnum;
        if (param == null || StringUtils.isEmpty((String)param.getAccountCode())) {
            return Maps.newHashMap();
        }
        if (StringUtils.isEmpty((String)param.getAccountType())) {
            param.setAccountType(AccountTypeDynamicEnum.CUSTOMER.getCode());
        }
        if ((accountTypeDynamicEnum = AccountTypeDynamicEnum.getAccountTypeEnumsByCode(param.getAccountType())) == null || accountTypeDynamicEnum.getFilerBeanCls() == null) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        AbstractScopeFilter filter = PromotionUtil.getBean(AbstractScopeFilter.class);
        if (filter == null) {
            return Maps.newHashMap();
        }
        List<String> promotionCodes = filter.apply(param);
        if (CollectionUtil.listEmpty(promotionCodes)) {
            return Maps.newHashMap();
        }
        List<PromotionEditVo> promotionEditVos = PromotionUtil.getCacheList(promotionCodes, this.promotionService);
        promotionEditVos.forEach(p -> {
            List promotionProductVos = (List)p.getProductMap().get("currentProducts");
            if (CollectionUtil.listNotEmpty((List)promotionProductVos)) {
                promotionProductVos.forEach(product -> result.put(product.getProductCode(), true));
            }
        });
        return result;
    }
}

