/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.nebular.dms.notice.NoticeVisitedLogVo;
import com.biz.crm.notice.entity.NoticeVisitedLogEntity;
import com.biz.crm.notice.mapper.NoticeVisitedLogMapper;
import com.biz.crm.notice.service.NoticeService;
import com.biz.crm.notice.service.NoticeVisitedLogService;
import com.biz.crm.util.ValidateUtils;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"noticeVisitedLogServiceExpandImpl"})
@Service(value="noticeVisitedLogService")
public class NoticeVisitedLogServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<NoticeVisitedLogMapper, NoticeVisitedLogEntity>
implements NoticeVisitedLogService {
    @Resource
    private NoticeService noticeService;
    @Resource
    private NoticeVisitedLogMapper noticeVisitedLogMapper;

    @Override
    @Klock(keys={"NOTICELOGLOCK", "#noticeVisitedLogVo.cusCode"}, waitTime=20L, leaseTime=5L)
    @Transactional
    public void readNotice(NoticeVisitedLogVo noticeVisitedLogVo) {
        ValidateUtils.validate((Object)noticeVisitedLogVo.getNoticeId(), (String)"\u8bf7\u6307\u5b9a\u67e5\u8be2\u7684\u516c\u544a");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"notice_id", (Object)noticeVisitedLogVo.getNoticeId());
        wrapper.eq((Object)"cus_code", (Object)noticeVisitedLogVo.getCusCode());
        NoticeVisitedLogEntity entity = (NoticeVisitedLogEntity)((Object)this.noticeVisitedLogMapper.selectOne((Wrapper)wrapper));
        if (null != entity) {
            return;
        }
        entity = new NoticeVisitedLogEntity();
        BeanUtils.copyProperties((Object)noticeVisitedLogVo, (Object)((Object)entity));
        this.noticeVisitedLogMapper.insert((Object)entity);
        this.noticeService.updateVisitNum(noticeVisitedLogVo.getNoticeId());
    }
}

