/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.beans.filters;

import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionProductVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionSaleProductVo;
import com.biz.crm.promotion.service.npromotion.beans.BaseFilter;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractMoqFilter
implements BaseFilter {
    public static final String MOQ_MATCH_MSG_OK = "OK";
    public static final String MOQ_MATCH_MSG_ERROR = "ERROR";

    public abstract String moqApply(PromotionEditVo var1, List<PromotionSaleProductVo> var2);

    protected String perProductFilter(List<PromotionProductVo> promotionCurrentProducts, List<PromotionSaleProductVo> saleProductVos) {
        if (CollectionUtil.listEmpty(saleProductVos) || CollectionUtil.listEmpty(promotionCurrentProducts)) {
            return MOQ_MATCH_MSG_ERROR;
        }
        String msg = new String();
        Map<String, PromotionSaleProductVo> buyProductMap = saleProductVos.stream().collect(Collectors.toMap(PromotionSaleProductVo::getProductCode, a -> a, (a, b) -> a));
        for (int i = 0; i < promotionCurrentProducts.size(); ++i) {
            PromotionProductVo promotionProductVo = promotionCurrentProducts.get(i);
            PromotionSaleProductVo buyProductVo = buyProductMap.get(promotionProductVo.getProductCode());
            if (buyProductVo == null) {
                buyProductVo = new PromotionSaleProductVo();
            }
            BigDecimal buyQuantity = Objects.equals("amount", promotionProductVo.getProductOrderQtyType()) ? buyProductVo.getBuyAmount() : buyProductVo.getBuyCount();
            if ((buyQuantity = buyQuantity == null ? BigDecimal.ZERO : buyQuantity).compareTo(promotionProductVo.getProductOrderQty() == null ? BigDecimal.ZERO : promotionProductVo.getProductOrderQty()) >= 0) continue;
            msg = String.join((CharSequence)",", msg, String.format("\u672c\u54c1\u3010%s\u3011\u8d2d\u4e70\u91cf\u672a\u6ee1\u8db3\u653f\u7b56\u8d77\u8ba2\u91cf", promotionProductVo.getProductName()));
        }
        if (StringUtils.isEmpty((String)msg)) {
            msg = MOQ_MATCH_MSG_OK;
        }
        return msg;
    }

    protected String composeProductFilter(boolean composeState, BigDecimal quantity, String quantityType, List<PromotionProductVo> promotionCurrentProducts, List<PromotionSaleProductVo> saleProductVos) {
        boolean flag;
        if (!composeState) {
            return MOQ_MATCH_MSG_OK;
        }
        Map<String, List<PromotionSaleProductVo>> saleProductsMap = saleProductVos.stream().collect(Collectors.groupingBy(PromotionSaleProductVo::getProductCode));
        BigDecimal buyQuantity = BigDecimal.ZERO;
        for (PromotionProductVo productVo : promotionCurrentProducts) {
            BigDecimal productQuantity = this.getBuyQuantity(quantityType, saleProductsMap, productVo);
            buyQuantity = buyQuantity.add(productQuantity == null ? BigDecimal.ZERO : productQuantity);
        }
        boolean bl = flag = buyQuantity.compareTo(quantity == null ? BigDecimal.ZERO : quantity) >= 0;
        if (!flag) {
            return "\u5f53\u524d\u653f\u7b56\u8981\u6c42\u7684\u7ec4\u5408\u8d77\u8ba2\u91cf\u672a\u8fbe\u5230";
        }
        return MOQ_MATCH_MSG_OK;
    }

    protected BigDecimal getBuyQuantity(String quantityType, Map<String, List<PromotionSaleProductVo>> saleProductsMap, PromotionProductVo productVo) {
        BigDecimal quantity = BigDecimal.ZERO;
        List<PromotionSaleProductVo> saleProducts = saleProductsMap.get(productVo.getProductCode());
        if (CollectionUtil.listEmpty(saleProducts)) {
            return BigDecimal.ZERO;
        }
        for (PromotionSaleProductVo saleProductVo : saleProducts) {
            quantity = quantity.add("amount".equals(quantityType) ? saleProductVo.getBuyAmount() : saleProductVo.getBuyCount());
        }
        return quantity;
    }
}

