/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component.function;

import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.promotion.service.component.function.param.TestRuleParam;
import com.biz.crm.promotion.service.component.function.response.ConditionRuleResponse;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.ValidateUtils;
import java.math.BigDecimal;
import java.util.List;

public abstract class AbstractCalculateRuleFunction<Param extends CalculateRuleParam, Resp extends CalculateRuleResponse>
implements RuleFunction<Param, Resp> {
    @Override
    public Resp test(TestRuleParam ruleParam) {
        PromotionRuleEditVo.TestParam testParam = ruleParam.getTestParam();
        ValidateUtils.validate((Object)testParam, (String)"\u6d4b\u8bd5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)testParam.getBizParam(), (String)"\u6d4b\u8bd5\u53c2\u6570[BizParam]\u4e0d\u80fd\u4e3a\u7a7a!");
        CalculateRuleParam calculateRuleParam = new CalculateRuleParam();
        String productOrderBuyStr = JsonPropertyUtil.toJsonString(testParam.getBizParam().get("productOrderBuy"));
        ValidateUtils.validate((Object)productOrderBuyStr, (String)"\u6d4b\u8bd5\u53c2\u6570[BizParam.productOrderBuy]\u4e0d\u80fd\u4e3a\u7a7a!");
        List productOrderBuy = JsonPropertyUtil.toArray((String)productOrderBuyStr, RuleExecuteParam.ProductOrderBuy.class);
        calculateRuleParam.setProductOrderBuy(productOrderBuy);
        String ladderListStr = JsonPropertyUtil.toJsonString(testParam.getBizParam().get("ladderList"));
        ValidateUtils.validate((Object)ladderListStr, (String)"\u6d4b\u8bd5\u53c2\u6570[BizParam.ladderList]\u4e0d\u80fd\u4e3a\u7a7a!");
        List ladderList = JsonPropertyUtil.toArray((String)ladderListStr, PromotionRuleEditVo.ControlRow.class);
        calculateRuleParam.setLadderList(ladderList);
        String conditionRuleFunctionBeanName = testParam.getBizParam().get("conditionRuleFunctionBeanName").toString();
        ValidateUtils.validate((Object)conditionRuleFunctionBeanName, (String)"\u6d4b\u8bd5\u53c2\u6570[BizParam.conditionRuleFunctionBeanName]\u4e0d\u80fd\u4e3a\u7a7a!");
        calculateRuleParam.setConditionRuleFunctionBeanName(conditionRuleFunctionBeanName);
        calculateRuleParam.setRuleCode(ruleParam.getRuleCode());
        return (Resp)((CalculateRuleResponse)this.apply(calculateRuleParam));
    }

    protected void buildRemainder(List<RuleExecuteParam.ProductOrderBuy> productOrderBuy, BigDecimal remainder, RuleFunction<ConditionRuleParam, ConditionRuleResponse> ruleFunction) {
        productOrderBuy.forEach(buy -> {
            FieldHandleUtil.initDecimalZero(buy);
            BigDecimal money = buy.getProductBuyAmount();
            BigDecimal qua = buy.getProductBuyNo();
            BigDecimal price = qua.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : money.divide(qua, 6, 0);
            String conditionType = ruleFunction.getConditionType();
            if (CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.AMOUNT.getItemCode().equals(conditionType)) {
                buy.setProductBuyAmount(remainder);
                buy.setProductBuyNo(remainder.divide(price, 6, 0));
            } else {
                buy.setProductBuyNo(remainder);
                buy.setProductBuyAmount(remainder.multiply(price));
            }
        });
    }
}

