/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salecontract.service.listener.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.liabilityforbreach.service.LiabilityForBreachService;
import com.biz.crm.nebular.dms.liablityforbreache.LiabilityForBreachVo;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.salecontract.service.listener.AbstractContractModelListener;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="contractLiabilityForBreachListener")
@ConditionalOnMissingBean(name={"contractLiabilityForBreachListenerExtend"})
public class ContractLiabilityForBreachListener
implements AbstractContractModelListener {
    @Resource
    private LiabilityForBreachService liabilityForBreachService;

    @Override
    @Transactional
    public JSONArray add(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
        if (CollectionUtil.jsonArrayEmpty((JSONArray)data)) {
            return new JSONArray();
        }
        ValidateUtils.validate((Object)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)saleContractVo, (String)"\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a");
        return this.edit(data, contractCode, jsonName, saleContractVo, indexCode);
    }

    @Override
    @Transactional
    public JSONArray edit(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
        ValidateUtils.validate((Object)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)saleContractVo, (String)"\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a");
        List<LiabilityForBreachVo> vos = BeanCopyUtil.parseByJSONArray(data, LiabilityForBreachVo.class);
        List<LiabilityForBreachVo> result = this.liabilityForBreachService.replace(vos, contractCode);
        return BeanCopyUtil.formatJSONArray(result);
    }

    @Override
    public JSONArray findByContractCode(String contractCode, String jsonName, String indexCode) {
        LiabilityForBreachVo result = this.liabilityForBreachService.findLiabilityBySaleContractCode(contractCode);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)result);
        return jsonArray;
    }
}

