/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.minbuynumofproduct.utils;

import com.biz.crm.base.BusinessException;
import com.biz.crm.minbuynumofproduct.entity.MinBuyNumOfProductEntity;
import com.biz.crm.nebular.dms.minbuynumofproduct.MinBuyNumOfProductVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.util.StringUtils;

public class MinBuyNumOfProductUtil {
    public static void validParamBatch(ArrayList<MinBuyNumOfProductVo> minBuyNumOfProductVos) {
        minBuyNumOfProductVos.stream().forEach(minBuyNumOfProductVo -> MinBuyNumOfProductUtil.validParam(minBuyNumOfProductVo));
    }

    public static void validParam(MinBuyNumOfProductVo minOrderVo) {
        ValidateUtils.validate((Object)minOrderVo.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ValidateUtils.validate((Object)minOrderVo.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        boolean flag = false;
        if (!StringUtils.isEmpty((Object)minOrderVo.getOrgCode()) && !StringUtils.isEmpty((Object)minOrderVo.getOrgName())) {
            flag = true;
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getCusCode()) && !StringUtils.isEmpty((Object)minOrderVo.getCusName())) {
            flag = true;
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getTerminalCode()) && !StringUtils.isEmpty((Object)minOrderVo.getTerminalName())) {
            flag = true;
        }
        if (!flag) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3001\u5ba2\u6237\u6216\u7ec8\u7aef\uff01");
        }
        ValidateUtils.validate((Object)minOrderVo.getVerificationMode(), (String)"\u8bf7\u6307\u5b9a\u9a8c\u8bc1\u65b9\u5f0f\uff01");
        ValidateUtils.validate((Object)minOrderVo.getMinOrderQuantity(), (String)"\u8d77\u8ba2\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    public static List<MinBuyNumOfProductEntity> assembleEntities(ArrayList<MinBuyNumOfProductVo> minOrderVos) {
        List minOrderEntities = CrmBeanUtil.copyList(minOrderVos, MinBuyNumOfProductEntity.class);
        return minOrderEntities.stream().map(minOrderEntity -> {
            minOrderEntity.setId(UUIDGenerator.generate());
            minOrderEntity.setOnlyKey(MinBuyNumOfProductUtil.getOnlyKey(minOrderEntity));
            return minOrderEntity;
        }).collect(Collectors.toList());
    }

    private static String getOnlyKey(MinBuyNumOfProductEntity minOrderEntity) {
        StringBuilder key = new StringBuilder();
        if (!StringUtils.isEmpty((Object)minOrderEntity.getOrgCode())) {
            key.append(minOrderEntity.getOrgCode());
        } else if (!StringUtils.isEmpty((Object)minOrderEntity.getCusCode())) {
            key.append(minOrderEntity.getCusCode());
        } else {
            key.append(minOrderEntity.getTerminalCode());
        }
        key.append(minOrderEntity.getProductCode());
        return key.toString();
    }

    public static BoolQueryBuilder buildQuery(MinBuyNumOfProductVo minOrderVo) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)minOrderVo.getProductCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productCode", (Object)minOrderVo.getProductCode()));
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getProductName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productName", (Object)minOrderVo.getProductName()));
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getOrgCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"orgCode", (Object)minOrderVo.getOrgCode()));
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getOrgName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"orgName", (Object)minOrderVo.getOrgName()));
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getCusCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"cusCode", (Object)minOrderVo.getCusCode()));
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getCusName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"cusName", (Object)minOrderVo.getCusName()));
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getTerminalCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"terminalCode", (Object)minOrderVo.getTerminalCode()));
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getTerminalName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"terminalName", (Object)minOrderVo.getTerminalName()));
        }
        if (minOrderVo.getEffectiveFlag() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"effectiveFlag", (Object)minOrderVo.getEffectiveFlag()));
        }
        return boolQueryBuilder;
    }
}

