/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.npromotion.beans;

import com.biz.crm.nebular.dms.npromotion.bo.CalculateParamBo;
import com.biz.crm.nebular.dms.npromotion.bo.CalculateResultBo;
import com.biz.crm.nebular.dms.npromotion.bo.ConditionParamBo;
import com.biz.crm.nebular.dms.npromotion.bo.ConditionResultBo;
import com.biz.crm.nebular.dms.npromotion.bo.LadderParseBo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionProductVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionSaleProductVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.TestRuleParam;
import com.biz.crm.promotion.service.npromotion.beans.AbstractConditionComputer;
import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.util.CollectionUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractCalculateComputer
implements RuleFunction<CalculateRuleParam, CalculateRuleResponse> {
    public static final int SINGLE = 1;
    public static final int LADDER = 2;
    public static final int LADDER_LOOP = 3;
    public static final String UPPER_LIMITED_MSG_PROCESS = "process";

    public CalculateResultBo calculateApply(CalculateParamBo param) {
        CalculateResultBo result = new CalculateResultBo();
        result.setMatchState(false);
        if (param == null) {
            result.setMatchMsg("\u7a0b\u5e8f\u5f02\u5e38\uff1a\u4f20\u5165\u6761\u4ef6\u53c2\u6570\u4e3a\u7a7a");
            return result;
        }
        AbstractConditionComputer conditionComputer = PromotionUtil.getBean(param.getConditionRuleFunctionBeanName(), AbstractConditionComputer.class);
        if (conditionComputer == null) {
            result.setMatchMsg(String.format("\u6ca1\u6709\u83b7\u53d6\u5230\u6761\u4ef6\u89c4\u5219\u51fd\u6570\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u7684\u51fd\u6570\u540d\u79f0%s\u662f\u5426\u6b63\u786e", param.getConditionRuleFunctionBeanName()));
            return result;
        }
        List ladderList = param.getLadderList();
        ArrayList usedLadders = Lists.newArrayList();
        if (CollectionUtil.listEmpty((List)ladderList)) {
            result.setMatchMsg("\u4f20\u5165\u7684\u9636\u68af\u4e3a\u7a7a:\u8bf7\u68c0\u67e5\u4fc3\u9500\u662f\u5426\u914d\u7f6e\u4e86\u8ba1\u7b97\u9636\u68af");
            return result;
        }
        boolean matchState = false;
        String matchMsg = new String();
        BigDecimal value = null;
        String valueType = null;
        String unitType = null;
        ConditionParamBo conditionParam = new ConditionParamBo();
        this.buildConditionValue(conditionParam, param.getSaleProductVos(), param.getCurrentProductVos());
        for (int i = 0; i < ladderList.size(); ++i) {
            PromotionRuleEditVo.ControlRow ladder = (PromotionRuleEditVo.ControlRow)ladderList.get(i);
            conditionParam.setLadder(ladder);
            LadderParseBo ladderParseBo = conditionComputer.parseLadder(ladder);
            conditionParam.setLadderParseBo(ladderParseBo);
            ConditionResultBo conditionResultBo = conditionComputer.conditionApply(conditionParam);
            BigDecimal multiple = conditionResultBo.getMultiple();
            BigDecimal remainder = conditionResultBo.getRemainder();
            if (multiple.compareTo(BigDecimal.ZERO) != 1) continue;
            String upperLimitedMsg = this.validateUpperLimited(conditionResultBo.getValue(), param);
            if (!UPPER_LIMITED_MSG_PROCESS.equals(upperLimitedMsg)) {
                matchMsg = String.join((CharSequence)",", matchMsg, upperLimitedMsg);
                continue;
            }
            matchState = true;
            matchMsg = String.join((CharSequence)",", matchMsg, String.format("\u5339\u914d\u5230\u7b2c%d\u7ea7\u9636\u68af", i + 1));
            valueType = conditionResultBo.getValueType();
            unitType = conditionResultBo.getUnitType();
            if (value == null) {
                value = BigDecimal.ZERO;
            }
            if (conditionResultBo.getValue() != null) {
                value = 1 == this.getLadderType() ? value.add(conditionResultBo.getValue()) : value.add(conditionResultBo.getValue().multiply(conditionResultBo.getMultiple()));
            }
            usedLadders.add(ladder);
            if (1 == this.getLadderType()) break;
            if (2 != this.getLadderType()) continue;
            this.refreshConditionParam(conditionParam, remainder, ladderParseBo.getSourceValueType());
        }
        if (matchMsg.startsWith(",")) {
            matchMsg = matchMsg.substring(1);
        }
        result.setMatchState(matchState);
        result.setMatchMsg(matchMsg);
        result.setValue(value);
        result.setUnitType(unitType);
        result.setValueType(valueType);
        result.setLadderUsed((List)usedLadders);
        result.setCurrentProductVos(param.getCurrentProductVos());
        result.setGiftProductVos(param.getGiftProductVos());
        if (!matchState) {
            result.setMatchMsg("\u6ca1\u6709\u547d\u4e2d\u4efb\u4f55\u9636\u68af");
        }
        if (value != null && value.compareTo(param.getVariable()) > 0) {
            result.setMatchState(false);
            result.setMatchMsg("\u653f\u7b56\u53ef\u7528\u4f59\u91cf\u4e0d\u8db3");
        }
        return result;
    }

    protected String validateUpperLimited(BigDecimal value, CalculateParamBo param) {
        if (param.getVariable() == null) {
            return UPPER_LIMITED_MSG_PROCESS;
        }
        if (param.getVariable().compareTo(value == null ? BigDecimal.ZERO : value) < 0) {
            return "\u8be5\u9636\u68af\u8d85\u8fc7\u653f\u7b56\u4e0a\u9650\uff0c\u65e0\u6cd5\u547d\u4e2d";
        }
        param.setVariable(param.getVariable().subtract(value == null ? BigDecimal.ZERO : value));
        return UPPER_LIMITED_MSG_PROCESS;
    }

    protected void buildConditionValue(ConditionParamBo conditionParam, List<PromotionSaleProductVo> saleProductVos, List<PromotionProductVo> currentProductVos) {
        if (conditionParam == null || CollectionUtil.listEmpty(saleProductVos)) {
            return;
        }
        Map<String, PromotionProductVo> currentProductVoMap = CollectionUtil.listEmpty(currentProductVos) ? saleProductVos.stream().collect(Collectors.toMap(PromotionSaleProductVo::getProductCode, a -> null, (a, b) -> a)) : currentProductVos.stream().collect(Collectors.toMap(PromotionProductVo::getProductCode, a -> a, (a, b) -> a));
        BigDecimal count = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        for (PromotionSaleProductVo productVo : saleProductVos) {
            PromotionProductVo currentProduct = currentProductVoMap.get(productVo.getProductCode());
            if (currentProduct == null) continue;
            count = count.add(productVo.getBuyCount());
            amount = amount.add(productVo.getBuyAmount());
        }
        conditionParam.setCount(count);
        conditionParam.setAmount(amount);
    }

    protected void refreshConditionParam(ConditionParamBo conditionParam, BigDecimal remainder, String valueType) {
        BigDecimal price;
        BigDecimal bigDecimal = price = conditionParam.getCount() == null || conditionParam.getCount().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : conditionParam.getAmount().divide(conditionParam.getCount(), 6, 0);
        if ("number".equals(valueType)) {
            conditionParam.setCount(remainder);
            conditionParam.setAmount(remainder.multiply(price));
        } else {
            conditionParam.setAmount(remainder);
            conditionParam.setCount(remainder.divide(price, 6, 0));
        }
    }

    protected int getLadderType() {
        return 1;
    }

    @Override
    public CalculateRuleResponse apply(CalculateRuleParam p) {
        return new CalculateRuleResponse();
    }

    @Override
    public CalculateRuleResponse test(TestRuleParam testRuleParam) {
        return new CalculateRuleResponse();
    }
}

