package com.biz.crm.companyinformation.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.companyinformation.service.CompanyInformationService;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@Api(value = "PC端-公司资料", tags = "PC端-公司资料")
@RestController
@RequestMapping(value = "/p/companyInformation")
public class CompanyInformationpController {

    @Resource
    private CompanyInformationService companyInformationService;

    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "分页搜索公司证件")
    @PostMapping(value = "list")
    public Result<PageResult<CompanyInformationVo>> list(@RequestBody CompanyInformationVo companyInformationVo){
        UserRedis userRedis = UserUtils.getUser();
        return Result.ok(companyInformationService.listByOrg(companyInformationVo,UserUtils.handleOrgCodes(userRedis.getOrgcode()) ,userRedis.getCustcode()));
    }
}
