package com.biz.crm.companyinformation.service;

import com.biz.crm.companyinformation.entity.CompanyInformationEntity;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationFileVo;

import java.util.List;
import java.util.Map;

/**
 * @Description:公司资料文件表
 * @Author: zhangyuzhu
 * @Date: 2020/9/10 14:42
 **/
public interface CompanyInformationFileService {

    /**
     * 根据资料主信息，批量保存文件
     * @param companyInformationEntity
     * @param files
     */
    void replace(CompanyInformationEntity companyInformationEntity, List<CompanyInformationFileVo> files);


    /**
     * 根据资料id查询文件信息(按照文件序号排序)
     * @param informationId
     * @return
     */
    List<CompanyInformationFileVo> findByInformationId(String informationId);

    /**
     * 根据资料ids查询文件信息(按照文件序号排序)
     * @param informationIds
     * @return
     */
    Map<String, List<CompanyInformationFileVo>> findByInformationIds(List<String> informationIds);

    /**
     * 根据公司资料id批量删除
     * @param informationIds
     */
    void delByInformationIds(List<String> informationIds);
}
