package com.biz.crm.companyinformation.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationVo;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 公司资料主表服务
 * @Author: zhangyuzhu
 * @Date: 2020/9/10 14:42
 **/
public interface CompanyInformationService {

    /**
     * 添加公司资料
     * @param companyInformationVo
     */
    void add(CompanyInformationVo companyInformationVo);


    /**
     * 编辑公司资料
     * @param companyInformationVo
     */
    void edit(CompanyInformationVo companyInformationVo);

    /**
     * 通过id查询对象
     * @param id
     * @return
     */
    CompanyInformationVo findById(String id);

    /**
     * 分页搜索
     * @param companyInformationVo
     * @return
     */
    PageResult<CompanyInformationVo> list(CompanyInformationVo companyInformationVo, String orgCode);


    /**
     * 分页搜索(PC)
     * @param companyInformationVo
     * @return
     */
    PageResult<CompanyInformationVo> listByOrg(CompanyInformationVo companyInformationVo, List<String> orgCodes, String cusCode);


    /**
     * 根据id批量删除或者恢复
     * @param ids
     */
    void delByIds(ArrayList<String> ids);


    /**
     * 根据查询条件批量删除
     * @param companyInformationVo
     */
    void delByParam(CompanyInformationVo companyInformationVo);
}
