package com.biz.crm.companyinformation.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.companyinformation.entity.CompanyInformationEntity;
import com.biz.crm.companyinformation.mapper.CompanyInformationMapper;
import com.biz.crm.companyinformation.service.CompanyInformationAreaService;
import com.biz.crm.companyinformation.service.CompanyInformationFileService;
import com.biz.crm.companyinformation.service.CompanyInformationService;
import com.biz.crm.companyinformation.utils.CompanyInformationAreaUtil;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.contract.entity.ContractEntity;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationAreaVo;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationFileVo;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationVo;
import com.biz.crm.nebular.dms.contract.ContractVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/10 14:42
 **/
@ConditionalOnMissingBean(name = "companyInformationServiceExpandImpl")
@Service(value = "companyInformationService")
public class CompanyInformationServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<CompanyInformationMapper, CompanyInformationEntity> implements CompanyInformationService {

    @Autowired
    private CompanyInformationMapper companyInformationMapper;

    @Resource
    private CompanyInformationFileService companyInformationFileService;

    @Resource
    private CompanyInformationAreaService companyInformationAreaService;

    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    /**
     * 1、验证主表参数
     * 2、组装保存
     * 3、保存文件
     * 4、保存区域
     * @param companyInformationVo
     */
    @Transactional
    @Override
    public void add(CompanyInformationVo companyInformationVo) {
        //1
        ValidateUtils.validate(companyInformationVo.getName(),"请指定资料名称!");
        ValidateUtils.validate(companyInformationVo.getType(),"请指定资料类型!");

        //2
        CompanyInformationEntity entity = new CompanyInformationEntity();
        BeanUtils.copyProperties(companyInformationVo,entity);
        companyInformationMapper.insert(entity);

        //3
        companyInformationFileService.replace(entity,companyInformationVo.getFiles());

        //4
        companyInformationAreaService.replace(entity, CompanyInformationAreaUtil.addAllAreas(companyInformationVo));
        //日志
        crmLogSendUtil.sendForAdd(ThreadLocalUtil.getObj(GlobalParam.MENU_CODE).toString(), entity.getId(),null,companyInformationVo);

    }

    /**
     * 1、验证主表参数
     * 2、组装保存
     * 3、保存文件
     * 4、保存区域
     * @param companyInformationVo
     */
    @Transactional
    @Override
    public void edit(CompanyInformationVo companyInformationVo) {
        //1
        ValidateUtils.validate(companyInformationVo.getId(),"请指定要编辑的资料!");
        ValidateUtils.validate(companyInformationVo.getName(),"请指定资料名称!");
        ValidateUtils.validate(companyInformationVo.getType(),"请指定资料类型!");
        CompanyInformationEntity entity = companyInformationMapper.selectById(companyInformationVo.getId());
        ValidateUtils.validate(entity,"您要编辑的资料不存在或者已经被删除!");

        //2
        BeanUtils.copyProperties(companyInformationVo,entity);

        CompanyInformationVo oldObject = this.findById(companyInformationVo.getId());
        companyInformationMapper.updateById(entity);

        //3
        companyInformationFileService.replace(entity,companyInformationVo.getFiles());

        //4
        companyInformationAreaService.replace(entity,CompanyInformationAreaUtil.addAllAreas(companyInformationVo));
        CompanyInformationVo newObject = this.findById(companyInformationVo.getId());
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), companyInformationVo.getId(),null,oldObject,newObject);
    }

    /**
     * 1、先查询主信息并且组装
     * 2、查询文件信息并且组装
     * 3、查询范围信息并且组装
     * @param id
     * @return
     */
    @CrmDictMethod
    @Override
    public CompanyInformationVo findById(String id) {
        CompanyInformationVo vo = null;
        //1
        ValidateUtils.validate(id,"请指定需要查询的资料！");
        CompanyInformationEntity entity = companyInformationMapper.selectById(id);
        if(null == entity){
            return vo;
        }
        vo = new CompanyInformationVo();
        BeanUtils.copyProperties(entity,vo);

        //2
        vo.setFiles(companyInformationFileService.findByInformationId(vo.getId()));

        //3
        Map<String, List<CompanyInformationAreaVo>> areaMap = CompanyInformationAreaUtil.distArea(companyInformationAreaService.findByInformationId(id));
        vo.setOrgs(areaMap.get("org"));
        vo.setNonOrgs(areaMap.get("nonOrg"));
        vo.setCustomers(areaMap.get("customer"));
        vo.setNonCustomers(areaMap.get("nonCustomer"));
        return vo;
    }
    /**
    　　* @description: 通过ids批量查询
     * 1、先查询主信息并且组装
     * 2、查询文件信息并且组装
    　　* @param
    　　* @return
    　　* @throws
    　　* @author YuDaiXuan
    　　* @date 2021/3/4 15:45
    　　*/
    public List<CompanyInformationVo> findByIds(ArrayList ids){
        //1
        ValidateUtils.isEmpty(ids,"请指定需要查询的资料！");
        List<CompanyInformationVo> list = companyInformationMapper.selectBatchIds(ids);
        //2
        //根据ids查询文件信息
        Map byInformationIds = companyInformationFileService.findByInformationIds(ids);

        for(int i =0;i<list.size();i++){
            for(Object key:byInformationIds.keySet()){
                if(key.equals(list.get(i))){
                    list.get(i).setFiles((List<CompanyInformationFileVo>) byInformationIds.get(key));
                    break;
                }
            }
        }
        return list;
    }
    @CrmDictMethod
    @Override
    public PageResult<CompanyInformationVo> list(CompanyInformationVo companyInformationVo, String orgCode) {
        QueryWrapper<CompanyInformationVo> wrapper = Wrappers.<CompanyInformationVo>query()
                .like(!StringUtils.isEmpty(companyInformationVo.getName()), "name", companyInformationVo.getName())
                .eq(null != companyInformationVo.getType(), "type", companyInformationVo.getType())
                .orderByDesc("create_date", "create_date_second");
        Page<CompanyInformationVo> page = PageUtil.buildPage(companyInformationVo.getPageNum(), companyInformationVo.getPageSize());
        List<CompanyInformationVo> list = companyInformationMapper.list(page,wrapper);
        return PageResult.<CompanyInformationVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<CompanyInformationVo> listByOrg(CompanyInformationVo companyInformationVo, List<String> orgCodes,String cusCode) {
        Page<CompanyInformationVo> page = PageUtil.buildPage(companyInformationVo.getPageNum(), companyInformationVo.getPageSize());
        //查询所有上级组织
        orgCodes = CollectionUtils.isEmpty(orgCodes)?new ArrayList<>():orgCodes;
        List<String> orgList = this.findParentOrgs(orgCodes);
        orgList = CollectionUtils.isEmpty(orgList)?new ArrayList<>():orgList;
        orgList.addAll(orgCodes);
        List<CompanyInformationVo> list = companyInformationMapper.listByOrg(page,
                orgList,cusCode,
                YesNoEnum.YesNoCodeNumberEnum.NO.getCode(),
                YesNoEnum.YesNoCodeNumberEnum.YES.getCode(),
                companyInformationVo.getName(),companyInformationVo.getType());
       if(!CollectionUtils.isEmpty(list)){
           Map<String, List<CompanyInformationFileVo>> fileMap = companyInformationFileService.findByInformationIds(list.stream().map(CompanyInformationVo::getId).collect(Collectors.toList()));
           for(CompanyInformationVo vo : list){
               vo.setFiles(fileMap.get(vo.getId()));
           }
       }
        return PageResult.<CompanyInformationVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询所有父级组织
     * @param orgCodes
     * @return
     */
    private List<String> findParentOrgs(List<String> orgCodes) {
        if(CollectionUtil.listEmpty(orgCodes)) {
            return Lists.newArrayList();
        }
        List<String> orgList = Lists.newArrayList();
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
        orgCodes.forEach(code -> {
            mdmOrgReqVo.setOrgCode(code);
            List<MdmOrgRespVo> parentList = ApiResultUtil.objResult(mdmOrgFeign.findAllParentOrgList(mdmOrgReqVo), true);
            if(!CollectionUtil.listEmpty(parentList)) {
                parentList.forEach(parent -> orgList.add(parent.getOrgCode()));
            }
        });
        return orgList;
    }

    /**
     * 查找所有下级组织
     * @param orgCodes
     * @return
     */
    private List<String> findChildrenOrg(List<String> orgCodes) {
        if(CollectionUtil.listEmpty(orgCodes)) {
            return Lists.newArrayList();
        }
        List<String> orgList = Lists.newArrayList();
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
        orgCodes.forEach(code -> {
            mdmOrgReqVo.setOrgCode(code);
            List<MdmOrgRespVo> parentList = ApiResultUtil.objResult(mdmOrgFeign.findAllChildrenOrgList(mdmOrgReqVo), true);
            if(!CollectionUtil.listEmpty(parentList)) {
                parentList.forEach(parent -> orgList.add(parent.getOrgCode()));
            }
        });
        return orgList;
    }

    /**
     * 1、删除主干信息
     * 2、删除文件和区域
     * @param ids
     */
    @Transactional
    @Override
    public void delByIds(ArrayList<String> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return;
        }

        //1
        companyInformationMapper.deleteBatchIds(ids);

        QueryWrapper<CompanyInformationVo> wrapper = Wrappers.<CompanyInformationVo>query()
                .in("id", ids);
        Page<CompanyInformationVo> page = PageUtil.buildPage(1,1000);
        List<CompanyInformationVo> contractVos = companyInformationMapper.list(page, wrapper);
        //2
        companyInformationFileService.delByInformationIds(ids);
        companyInformationAreaService.delByInformationIds(ids);

        for(CompanyInformationVo vo : contractVos){
            crmLogSendUtil.sendForDel(ThreadLocalUtil.getObj(GlobalParam.MENU_CODE).toString(),
                    vo.getId(),null,vo);
        }
    }

    /**
     * 1、删除主干信息
     * 2、删除文件和区域
     * @param companyInformationVo
     */
    @Transactional
    @Override
    public void delByParam(CompanyInformationVo companyInformationVo) {
        if(null == companyInformationVo){
            throw new BusinessException("请指定查询条件!");
        }
        QueryWrapper<CompanyInformationEntity> wrapper = Wrappers.<CompanyInformationEntity>query()
                .like(!StringUtils.isEmpty(companyInformationVo.getName()), "name", companyInformationVo.getName())
                .eq(null != companyInformationVo.getType(), "type", companyInformationVo.getType());
        List<CompanyInformationEntity> entities = companyInformationMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(entities)){
            return ;
        }
        List<String> ids = entities.stream()
                .map(CompanyInformationEntity::getId)
                .collect(Collectors.toList());

        //1
        companyInformationMapper.delete(wrapper);

        //2
        companyInformationFileService.delByInformationIds(ids);
        companyInformationAreaService.delByInformationIds(ids);
        for(CompanyInformationEntity entity : entities){
            crmLogSendUtil.sendForDel(ThreadLocalUtil.getObj(GlobalParam.MENU_CODE).toString(),
                    entity.getId(),null,entity);
        }
    }
}
