package com.biz.crm.companyinformation.utils;

import com.biz.crm.companyinformation.entity.CompanyInformationAreaEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationAreaVo;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationVo;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/14 15:04
 **/
public class CompanyInformationAreaUtil {


    /**
     * 将所有的区域组装成一起
     * @param companyInformationVo
     * @return
     */
    public static List<CompanyInformationAreaVo> addAllAreas(CompanyInformationVo companyInformationVo){
        List<CompanyInformationAreaVo> areaVos = new ArrayList<>();
        if(!CollectionUtils.isEmpty(companyInformationVo.getOrgs())){
            areaVos.addAll(companyInformationVo.getOrgs());
        }
        if(!CollectionUtils.isEmpty(companyInformationVo.getNonOrgs())){
            areaVos.addAll(companyInformationVo.getNonOrgs());
        }
        if(!CollectionUtils.isEmpty(companyInformationVo.getCustomers())){
            areaVos.addAll(companyInformationVo.getCustomers());
        }
        if(!CollectionUtils.isEmpty(companyInformationVo.getNonCustomers())){
            areaVos.addAll(companyInformationVo.getNonCustomers());
        }
        return areaVos;
    }


    /**
     * 设置抵消标志
     * @param entities
     * @return
     */
    public static List<CompanyInformationAreaEntity> judegeOffsetFlag(List<CompanyInformationAreaEntity> entities){
        if(CollectionUtils.isEmpty(entities)){
            return new ArrayList<>();
        }
        List<CompanyInformationAreaEntity> containEntities = entities.stream().filter(
                entitiy -> entitiy.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()
        ).collect(Collectors.toList());
        List<CompanyInformationAreaEntity> nonContainEntities = entities.stream().filter(
                entitiy -> entitiy.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue()
        ).collect(Collectors.toList());
        for(CompanyInformationAreaEntity entity : containEntities){
            entity.setOffsetFlag(YesNoEnum.YesNoCodeNumberEnum.NO.getCode());
            if(judegeFromNonContain(nonContainEntities,entity)){
                entity.setOffsetFlag(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
            }
        }
        for(CompanyInformationAreaEntity entity : nonContainEntities){
            entity.setOffsetFlag(YesNoEnum.YesNoCodeNumberEnum.NO.getCode());
        }
        List<CompanyInformationAreaEntity> reList = new ArrayList<>(entities.size());
        reList.addAll(containEntities);
        reList.addAll(nonContainEntities);
        return reList;
    }

    /**
     * 判断是否能被抵消 为judgeOffsetFlag方法的附属方法
     * @param nonContainEntities
     * @param entity
     * @return
     */
    public static boolean judegeFromNonContain(List<CompanyInformationAreaEntity> nonContainEntities,CompanyInformationAreaEntity entity){
        if(CollectionUtils.isEmpty(nonContainEntities)){
            return false;
        }
        for(CompanyInformationAreaEntity noEntity : nonContainEntities){
            if(!StringUtils.isEmpty(noEntity.getOrgCode()) && !StringUtils.isEmpty(entity.getOrgCode())
                    && noEntity.getOrgCode().equals(entity.getOrgCode())){
                return true;
            }
            if(!StringUtils.isEmpty(noEntity.getCusCode()) && !StringUtils.isEmpty(entity.getCusCode())
                    && noEntity.getCusCode().equals(entity.getCusCode())){
                return true;
            }
        }
        return false;
    }


    /**
     * 区分区域（如果没有则用空集合代替）
     * org->组织包含；nonOrg->组织非包含 customer->客户包含 nonCustomer->客户非包含
     * @param areaVos
     * @return
     */
    public static Map<String, List<CompanyInformationAreaVo>> distArea(List<CompanyInformationAreaVo> areaVos){
        Map<String,List<CompanyInformationAreaVo>> areaMap = new HashMap<>();
        List<CompanyInformationAreaVo> blankList = new ArrayList<>();
        areaMap.put("org",blankList);
        areaMap.put("nonOrg",blankList);
        areaMap.put("customer",blankList);
        areaMap.put("nonCustomer",blankList);
        if(CollectionUtils.isEmpty(areaVos)) {
            return areaMap;
        }
        List<CompanyInformationAreaVo> org = areaVos.stream()
                .filter(
                        areaVo -> !StringUtils.isEmpty(areaVo.getOrgCode())
                                && areaVo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()
                ).collect(Collectors.toList());

        List<CompanyInformationAreaVo> nonOrg = areaVos.stream()
                .filter(
                        areaVo -> !StringUtils.isEmpty(areaVo.getOrgCode())
                                && areaVo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue()
                ).collect(Collectors.toList());

        List<CompanyInformationAreaVo> customer = areaVos.stream()
                .filter(
                        areaVo -> !StringUtils.isEmpty(areaVo.getCusCode())
                                && areaVo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()
                ).collect(Collectors.toList());

        List<CompanyInformationAreaVo> nonCustomer = areaVos.stream()
                .filter(
                        areaVo -> !StringUtils.isEmpty(areaVo.getCusCode())
                                && areaVo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue()
                ).collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(org)){
            areaMap.put("org",org);
        }
        if(!CollectionUtils.isEmpty(nonOrg)){
            areaMap.put("nonOrg",nonOrg);
        }
        if(!CollectionUtils.isEmpty(customer)){
            areaMap.put("customer",customer);
        }
        if(!CollectionUtils.isEmpty(nonCustomer)){
            areaMap.put("nonCustomer",nonCustomer);
        }
        return areaMap;
    }

}
