package com.biz.crm.complaints.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.complaints.entity.ComplaintsContentEntity;
import com.biz.crm.complaints.mapper.ComplaintsContentMapper;
import com.biz.crm.complaints.service.ComplaintsContentService;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.dms.ComplaintsEunm;
import com.biz.crm.nebular.dms.complaints.ComplaintsReplyVo;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description:投诉内容类
 * @Author zhangyang
 * @Date 2021/5/18
 */
@ConditionalOnMissingBean(name = "complaintsContentServiceExpandImpl")
@Service(value = "complaintsContentService")
public class ComplaintsContentServiceImpl<M extends BaseMapper<T>,T>
        extends ServiceImpl<ComplaintsContentMapper, ComplaintsContentEntity>
        implements ComplaintsContentService {

    @Resource
    private ComplaintsContentMapper complaintsContentMapper;

    /**
     * 1.组装
     * 2.新增保存
     * @param complaintsId
     * @param content
     */
    @Transactional
    @Override
    public void add(String complaintsId, String content, String flag) {

        //1
        ComplaintsContentEntity complaintsContentEntity = new ComplaintsContentEntity();
        complaintsContentEntity.setComplaintsId(complaintsId);
        complaintsContentEntity.setContent(content);

        if(flag.equals(ComplaintsEunm.ComplaintsSubTypeEnum.CUSTOMER.getValue())){
            complaintsContentEntity.setSubmitterType(String.valueOf(ComplaintsEunm.ComplaintsSubTypeEnum.CUSTOMER.getCode()));
        }else {
            complaintsContentEntity.setSubmitterType(String.valueOf(ComplaintsEunm.ComplaintsSubTypeEnum.FACTORY.getCode()));
        }

        //2
        complaintsContentMapper.insert(complaintsContentEntity);
    }

    /**
     * 1.根据投诉建议id查询回复列表
     * 2.组装返回
     * @param complaintsId
     * @return
     */
    @CrmDictMethod
    @Override
    public List<ComplaintsReplyVo> contentById(String complaintsId) {

        //1
        List<ComplaintsContentEntity> contentEntities= complaintsContentMapper.selectList(
                new QueryWrapper<ComplaintsContentEntity>().eq("complaints_id", complaintsId).orderByAsc("create_date_all")
        );

        //2
        ArrayList<ComplaintsReplyVo> complaintsReplyVos = new ArrayList<>();
        for (ComplaintsContentEntity contentEntity : contentEntities) {
            ComplaintsReplyVo complaintsReplyVo = new ComplaintsReplyVo();
            BeanUtils.copyProperties(contentEntity,complaintsReplyVo);
            complaintsReplyVo.setSubmitter(contentEntity.getCreateName());
            complaintsReplyVos.add(complaintsReplyVo);
        }
        return complaintsReplyVos;
    }
}
