package com.biz.crm.complaints.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.complaints.entity.ComplaintsEntity;
import com.biz.crm.complaints.mapper.ComplaintsMapper;
import com.biz.crm.complaints.service.ComplaintsContentService;
import com.biz.crm.complaints.service.ComplaintsFileService;
import com.biz.crm.complaints.service.ComplaintsService;
import com.biz.crm.complaints.utils.ComplaintsOrderNoUtils;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.dms.ComplaintsEunm;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.dms.complaints.ComplaintsFileVo;
import com.biz.crm.nebular.dms.complaints.ComplaintsReplyVo;
import com.biz.crm.nebular.dms.complaints.ComplaintsRes;
import com.biz.crm.nebular.dms.complaints.ComplaintsVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Description:
 * @Author zhangyang
 * @Date 2021/5/18
 */
@ConditionalOnMissingBean(name = "complaintsServiceExpandImpl")
@Service(value = "complaintsService")
public class ComplaintsServiceImpl <M extends BaseMapper<T>,T>
        extends ServiceImpl<ComplaintsMapper, ComplaintsEntity>
        implements ComplaintsService {

    @Resource
    private ComplaintsMapper complaintsMapper;
    @Resource
    private ComplaintsContentService complaintsContentService;
    @Resource
    private ComplaintsFileService complaintsFileService;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    /**
     * 1.验证主表参数
     * 2.生成单号
     * 3.组装保存
     * 4.保存内容
     * 5.保存文件
     * @param ComplaintsVo
     */
    @Transactional
    @Override
    public void add(ComplaintsVo ComplaintsVo) {
        //1
        ValidateUtils.validate(ComplaintsVo.getComplaintsTitle(),"标题不能为空!");
        ValidateUtils.validate(ComplaintsVo.getComplaintsType(),"请指定类型!");
        ValidateUtils.validate(ComplaintsVo.getContent(),"内容不能为空!");

        //2
        String orderNo = ComplaintsOrderNoUtils.getOrderIdByTime();

        //3
        ComplaintsEntity complaintsEntity = new ComplaintsEntity();
        BeanUtils.copyProperties(ComplaintsVo,complaintsEntity);
        UserRedis userRedis = UserUtils.getUser();
        complaintsEntity.setComplaintsNo(orderNo);
        complaintsEntity.setCustomerCode(userRedis.getCustcode());
        complaintsEntity.setCustomerName(userRedis.getCustname());
        complaintsEntity.setComplaintsStatus(String.valueOf(ComplaintsEunm.ComplaintsStatusEnum.FACTORY.getCode()));
        complaintsMapper.insert(complaintsEntity);

        //4
        complaintsContentService.add(complaintsEntity.getId(),ComplaintsVo.getContent(),ComplaintsEunm.ComplaintsSubTypeEnum.CUSTOMER.getValue());

        //5
        if(null!=ComplaintsVo.getFiles()){
            complaintsFileService.add(complaintsEntity,ComplaintsVo.getFiles());
        }

    }

    /**
     * 1.验证参数
     * 2.保存回复内容
     * 3.改变回复状态(判断是p端还是m端)
     * 4.保存投诉建议
     * @param complaintsReplyVo
     */
    @Transactional
    @Override
    public void replyComplaints(ComplaintsReplyVo complaintsReplyVo,String flag) {
        //1
        ValidateUtils.validate(complaintsReplyVo.getComplaintsId(),"投诉建议id不能为空!");
        ValidateUtils.validate(complaintsReplyVo.getContent(),"内容不能为空!");

        //2
        complaintsContentService.add(complaintsReplyVo.getComplaintsId(),complaintsReplyVo.getContent(),flag);

        //3
        ComplaintsEntity complaintsEntity = complaintsMapper.selectById(complaintsReplyVo.getComplaintsId());
        complaintsEntity.setComplaintsStatus(flag);
        //4
        complaintsMapper.updateById(complaintsEntity);


    }

    /**
     * 1.验证参数
     * 2.改变回复状态
     * 3.保存投诉建议
     * @param complaintsId
     */
    @Transactional
    @Override
    public void solveComplaints(String complaintsId) {
        //1
        ValidateUtils.validate(complaintsId,"投诉建议id不能为空!");

        //2
        ComplaintsEntity complaintsEntity = complaintsMapper.selectById(complaintsId);
        complaintsEntity.setComplaintsStatus(String.valueOf(ComplaintsEunm.ComplaintsStatusEnum.FINISHED.getCode()));

        //3
        complaintsMapper.updateById(complaintsEntity);


    }


    /**
     * 分页列表
     * 1.创建分页对象
     * 2.查询分页数据
     * 3.返回构建分页对象
     * @param complaintsVo
     * @return
     */
    @Override
    @CrmDictMethod
    public PageResult<ComplaintsVo> list(ComplaintsVo complaintsVo) {
        //1
        Page<ComplaintsVo> page = PageUtil.buildPage(complaintsVo.getPageNum(),complaintsVo.getPageSize());

        //2
        List<ComplaintsVo> list = complaintsMapper.list(page,complaintsVo);

        //3
        return PageResult.<ComplaintsVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 1.查询投诉建议主体信息
     * 2.查询回复列表
     * 3.查询文件信息
     * 4.查询客户及对接人信息
     * 5.组合返回
     * @param id
     * @return
     */
    @CrmDictMethod
    @Override
    public ComplaintsRes detailById(String id,String flag) {
        
        //1
        ValidateUtils.validate(id,"请指定需要查询的投诉建议！");
        ComplaintsEntity complaintsEntity = complaintsMapper.selectById(id);
        ValidateUtils.validate(complaintsEntity,"这条投诉建议不存在！");
        ComplaintsVo complaintsVo = new ComplaintsVo();
        BeanUtils.copyProperties(complaintsEntity,complaintsVo);
        
        //2
        List<ComplaintsReplyVo> complaintsReplyVos = complaintsContentService.contentById(complaintsEntity.getId());

        //3
        List<ComplaintsFileVo> complaintsFileVos = complaintsFileService.filesById(complaintsEntity.getId());
        complaintsVo.setFiles(complaintsFileVos);

        ComplaintsRes complaintsRes = new ComplaintsRes();
        complaintsRes.setComplaintsVo(complaintsVo);
        complaintsRes.setReplyVos(complaintsReplyVos);
        if(flag.equals(ComplaintsEunm.ComplaintsStatusEnum.FACTORY.getValue())) {
            //4
            MdmCustomerMsgRespVo customerInfo = mdmCustomerMsgFeign.query(null, complaintsEntity.getCustomerCode()).getResult();
            complaintsRes.setCustomerInfo(customerInfo);
        }

        //5
        return complaintsRes;
    }
}
