package com.biz.crm.contract;

import com.biz.crm.base.BusinessException;
import com.biz.crm.contract.entity.ContractSalesAreaEntity;
import com.biz.crm.nebular.dms.contract.ContractSalesAreaVo;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Objects;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/21 14:31
 **/
public class ContractUtil {



    /**
     * 区域验重
     * @param salesAreas
     */
    public static void checkRepeat(List<ContractSalesAreaVo> salesAreas) {
        if(CollectionUtil.listEmpty(salesAreas)) {
            return;
        }
        List<ContractSalesAreaVo> nAreas = BeanCopyUtil.copyList(salesAreas, ContractSalesAreaVo.class);
        salesAreas.forEach(a -> {
            nAreas.remove(a);
            nAreas.forEach(b -> {
                /*
                逻辑：自上至下去重，
                从国->省->市->区域，只要检测到存在相同的，不管其是否还有下属区域均视为重复
                 */
                if (isNotBlankUnion(a.getCountryCode(), a.getProvinceCode(), a.getCityCode(), a.getDistrictCode())) {
                    ValidateUtils.isTrue(!Objects.equals(a.getDistrictCode(), b.getDistrictCode()), "检测到销售范围’%s%s%s%s‘与’%s%s%s%s‘重复",
                            a.getCountry(), a.getProvince(), a.getCity(), a.getDistrict()
                    ,b.getCountry(), b.getProvince(), b.getCity(), b.getDistrict());
                } else if (isNotBlankUnion(a.getCountryCode(), a.getProvinceCode(), a.getCityCode())) {
                    ValidateUtils.isTrue(!Objects.equals(a.getCityCode(), b.getCityCode()), "检测到销售范围‘%s%s%s’与‘%s%s%s%s’重复",
                            a.getCountry(), a.getProvince(), a.getCity()
                            ,b.getCountry(), b.getProvince(), b.getCity(), b.getDistrict());
                } else if (isNotBlankUnion(a.getCountryCode(), a.getProvinceCode())) {
                    ValidateUtils.isTrue(!Objects.equals(a.getProvinceCode(), b.getProvinceCode()), "检测到销售范围‘%s%s’与‘%s%s%s%s’重复",
                            a.getCountry(), a.getProvince()
                            ,b.getCountry(), b.getProvince(), b.getCity(), b.getDistrict());
                } else if(isNotBlankUnion(a.getCountryCode())) {
                    ValidateUtils.isTrue(!Objects.equals(a.getCountryCode(), b.getCountryCode()), "检测到销售范围’%s‘与‘%s%s%s%s’重复",
                            a.getCountry()
                            ,b.getCountry(), b.getProvince(), b.getCity(), b.getDistrict());
                }
                /*
                逻辑：精确去重，
                只有当存在两个或多个对象，国、省、市、区域，
                均相同（加入两个对象同一维度均为空，该维度也视为相同，如：两个对象‘市’都为空，则‘市’的为空视为相同），
                才视为重复
                 */
//                ValidateUtils.isTrue(!(Objects.equals(a.getCountryCode(), b.getCountryCode()) &&
//                        Objects.equals(a.getProvinceCode(), b.getProvinceCode()) &&
//                        Objects.equals(a.getCityCode(), b.getCityCode()) &&
//                        Objects.equals(a.getDistrictCode(), b.getDistrictCode())),
//                        "检测到存在重复区域：%s %s %s %s",
//                        a.getCountry(), a.getProvince(), a.getCity(), a.getDistrict());
            });
        });
    }

    /**
     * 校验每个字符串费用
     * @param str  字符串数组
     * @return
     */
    private static boolean isNotBlankUnion(String... str) {
        if(str == null) {
            return false;
        }
        for(String s : str) {
            if(StringUtils.isEmpty(s)) {
                return false;
            }
        }
        return true;
    }
}
