package com.biz.crm.contract.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.contract.entity.ContractEntity;
import com.biz.crm.contract.entity.ContractFileEntity;
import com.biz.crm.contract.mapper.ContractFileMapper;
import com.biz.crm.contract.service.ContractFileService;
import com.biz.crm.nebular.dms.contract.ContractFileVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/**
 * @Author: heyijiang
 * @Date: 2020/9/16 9:43
 */
@ConditionalOnMissingBean(name = "contractFileServiceExpandImpl")
@Service(value = "contractFileService")
public class ContractFileServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<ContractFileMapper, ContractFileEntity> implements ContractFileService {

    @Autowired
    private ContractFileMapper contractFileMapper;

    /**
     * 1、删除合同下所有文件
     * 2、组装
     * 3、保存
     * @param contractEntity
     * @param files
     */
    @Override
    @Transactional
    public void replace(ContractEntity contractEntity, List<ContractFileVo> files) {
        //1
        this.removeByMap(new HashMap<String, Object>(){
            {
                put("contract_id",contractEntity.getId());
            }
        });
        if(CollectionUtils.isEmpty(files)){
            return;
        }

        //2
        List<ContractFileEntity> entities = new ArrayList<>(files.size());
        int i = 1;
        for (ContractFileVo vo: files) {
            i++;
            vo.setSortNum(i);
            ContractFileEntity entity = new ContractFileEntity();
            BeanUtils.copyProperties(vo,entity);
            entity.setContractId(contractEntity.getId());
            entities.add(entity);
        }

        //3
        this.saveBatch(entities);
    }

    /**
     * 1、验证
     * 2、查询并且组装返回
     * @param contractId
     * @return
     */
    @Override
    public List<ContractFileVo> findByContractId(String contractId) {

        //1
        if(StringUtils.isEmpty(contractId)){
            return new ArrayList<>();
        }

        //2
        QueryWrapper<ContractFileEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", contractId);
        List<ContractFileEntity> fileEntities =  contractFileMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(fileEntities)){
            return new ArrayList<>();
        }
        List<ContractFileVo> fileVos = new ArrayList<>(fileEntities.size());
        for(ContractFileEntity entity : fileEntities){
            ContractFileVo fileVo = new ContractFileVo();
            BeanUtils.copyProperties(entity,fileVo);
            fileVos.add(fileVo);
        }
        Collections.sort(fileVos, (a,b)->a.getSortNum().compareTo(b.getSortNum()));
        return fileVos;
    }
}
