package com.biz.crm.contractdetails.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @author HP
 * @title: 合同细则实体类
 * @projectName crm
 * @description: TODO
 * @date 2021/2/209:37
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_sale_contract_details")
@CrmTable(name = "dms_sale_contract_details", indexes = {
        @Index(name = "index_sale_contract_details_code", columnList = "sale_contract_code")
},tableNote = "合同细则实体类")
public class ContractDetailsEntity extends CrmExtEntity  {
    /**
     *  合同编码
     */
    @CrmColumn(name = "sale_contract_code", length = 64)
    private String saleContractCode;
    /**
     *  合同细则
     */
    @CrmColumn(name = "contract_details", length = 4000)
    private String contractDetails;

}
