package com.biz.crm.contractdetails.service.Impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.dms.contractdetails.ContractDetailsVo;
import com.biz.crm.contractdetails.entity.ContractDetailsEntity;
import com.biz.crm.salecontract.entity.ContractTemplateTupleMappingEntity;
import com.biz.crm.contractdetails.mapper.ContractDetailsMapper;
import com.biz.crm.salecontract.mapper.ContractTemplateTupleMappingMapper;
import com.biz.crm.contractdetails.service.ContractDetailsService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author HP
 * @title: ContractDetailsServiceImpl
 * @projectName crm
 * @description: TODO
 * @date 2021/2/209:44
 */
@ConditionalOnMissingBean(name = "contractDetailsServiceImpl")
@Service(value = "contractDetailsService")
public class ContractDetailsServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<ContractDetailsMapper, ContractDetailsEntity> implements ContractDetailsService {

  @Resource
  private ContractDetailsMapper contractDetailsMapper;

  @Override
  @Transactional
  public ContractDetailsVo add(ContractDetailsVo contractDetailsVo) {
    //1、校验入参
    ValidateUtils.validate(contractDetailsVo.getSaleContractCode(), "合同编码不能为空");
    ValidateUtils.validate(contractDetailsVo.getContractDetails(), "合同细则不能为空");
    //2、校验合同编码是否存在
    ContractDetailsEntity contractDetailsEntitydb = contractDetailsMapper.selectOne(Wrappers.<ContractDetailsEntity>query().eq("sale_contract_code", contractDetailsVo.getSaleContractCode()));
    if (contractDetailsEntitydb != null) {
      Boolean f = false;
      ValidateUtils.isTrue(f, "合同编码已存在");
    }
//        //设置id
//        contractDetailsVo.setContractDetailsId(UUID.randomUUID().toString());
    //3、保存合同细则
    ContractDetailsEntity contractDetailsEntity = CrmBeanUtil.copy(contractDetailsVo, ContractDetailsEntity.class);
    int rtn = contractDetailsMapper.insert(contractDetailsEntity);
    ValidateUtils.isTrue(rtn == 1, "新增合同细则失败");
    return contractDetailsVo;
  }

  @Override
  public ContractDetailsVo findByContractCode(ContractDetailsVo contractDetailsVo) {
    //1、校验入参
    ValidateUtils.validate(contractDetailsVo.getSaleContractCode(), "合同编码不能为空");
    //2、查询
    ContractDetailsEntity dbDetails = contractDetailsMapper.selectOne(Wrappers.<ContractDetailsEntity>query().eq("sale_contract_code", contractDetailsVo.getSaleContractCode()));
    ValidateUtils.validate(dbDetails, "该合同没有合同细则信息");
    ContractDetailsVo contractDetailsVodb = CrmBeanUtil.copy(dbDetails, ContractDetailsVo.class);
    return contractDetailsVodb;
  }

  @Override
  @Transactional
  public ContractDetailsVo edit(ContractDetailsVo contractDetailsVo) {
    //1、校验入参
    ValidateUtils.validate(contractDetailsVo.getSaleContractCode(), "合同编码不能为空");
    ValidateUtils.validate(contractDetailsVo.getContractDetails(), "合同细则不能为空");
    //2、合同编码校验
    ContractDetailsEntity contractDetailsEntitydb = contractDetailsMapper.selectOne(Wrappers.<ContractDetailsEntity>query().eq("sale_contract_code", contractDetailsVo.getSaleContractCode()));
    if (contractDetailsEntitydb == null) {
      Boolean f = false;
      ValidateUtils.isTrue(f, "该合同细则不存在");
    }
    //3、修改合同细则
    ContractDetailsEntity contractDetailsEntity = CrmBeanUtil.copy(contractDetailsVo, ContractDetailsEntity.class);
    int rtn = contractDetailsMapper.update(contractDetailsEntity, Wrappers.<ContractDetailsEntity>query().eq("sale_contract_code", contractDetailsVo.getSaleContractCode()));
    ValidateUtils.isTrue(rtn == 1, "合同细则修改失败");
    return contractDetailsVo;
  }

  /**
   * 批量新增
   * @param vos
   * @param contractCode
   * @return
   */
  @Override
  @Transactional
  public List<ContractDetailsVo> addBatch(List<ContractDetailsVo> vos, String contractCode) {
    this.contractDetailsMapper.delete(Wrappers.<ContractDetailsEntity>query().eq("sale_contract_code", contractCode));
    if(CollectionUtil.listEmpty(vos)) {
      return Lists.newArrayList();
    }
    vos.forEach(vo -> vo.setSaleContractCode(contractCode));
    List<ContractDetailsEntity> entities = CrmBeanUtil.copyList(vos, ContractDetailsEntity.class);
    this.saveBatch(entities);
    return CrmBeanUtil.copyList(entities, ContractDetailsVo.class);
  }

  /**
   * 批量修改
   * @param vos
   * @param contractCode
   * @return
   */
  @Override
  @Transactional
  public List<ContractDetailsVo> editBatch(List<ContractDetailsVo> vos, String contractCode) {
    this.contractDetailsMapper.delete(Wrappers.<ContractDetailsEntity>query().eq("sale_contract_code", contractCode));
    return this.addBatch(vos, contractCode);
  }
}
