package com.biz.crm.liabilityforbreach.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.liabilityforbreach.service.LiabilityForBreachService;
import com.biz.crm.nebular.dms.liablityforbreache.LiabilityForBreachVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author liufan E-mail:fan.liu@biz-united.com.cn
 * @version 创建时间：2021/2/20
 */
@Api(value = "违约责任", tags = "违约责任")
@RestController
@RequestMapping(value = "/m/LiabilityForBreach")
public class LiabilityForBreachmController {

    @Resource
    private LiabilityForBreachService liabilityService;

    @CrmLog
    @ApiOperation(value = "查询合同的违约责任")
    @GetMapping("findLiabilityBySaleContractCode")
    public Result<LiabilityForBreachVo> findLiabilityBySaleContractCode(@RequestParam @ApiParam("合同编号") String saleContractCode) {
        LiabilityForBreachVo result = this.liabilityService.findLiabilityBySaleContractCode(saleContractCode);
        return Result.ok(result);
    }
}
