package com.biz.crm.minbuynumofproduct.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.minbuynumofproduct.service.MinBuyNumOfProductService;
import com.biz.crm.nebular.dms.minbuynumofproduct.FindByCusCodeAndProductCodesToCusReq;
import com.biz.crm.nebular.dms.minbuynumofproduct.MinBuyNumOfProductVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Map;

/**
 * @Author: huojia
 * @DateTime: 2021/1/25 16:27
 **/
@Api(value = "api-起订量", tags = "api-起订量")
@RestController
@RequestMapping("/api/minBuyNumOfProduct")
public class MinBuyNumOfProductApiController {

    @Resource
    private MinBuyNumOfProductService minBuyNumOfProductService;

    @CrmLog
    @ApiOperation(value = "通过客户及其组织查询产品的最小起订量")
    @PostMapping(value = "findByCusCodeAndProductCodesToCus")
    public Result findByCusCodeAndProductCodesToCus(@RequestBody FindByCusCodeAndProductCodesToCusReq findByCusCodeAndProductCodesToCusReq) {
        Map<String, MinBuyNumOfProductVo> result
                = minBuyNumOfProductService.findByCusCodeAndProductCodesToCus(
                findByCusCodeAndProductCodesToCusReq.getCusCode(),
                findByCusCodeAndProductCodesToCusReq.getOrgCode(),
                findByCusCodeAndProductCodesToCusReq.getProductCodes());
        return Result.ok(result);
    }
}