package com.biz.crm.minbuynumofproduct.repositories;

import com.biz.crm.minbuynumofproduct.entity.MinBuyNumOfProductEntity;
import org.springframework.data.repository.CrudRepository;

import java.util.List;

/**
 * @Author: huojia
 * @DateTime: 2021/1/25 19:45
 **/
public interface MinBuyNumOfProductRepositories extends CrudRepository<MinBuyNumOfProductEntity, String> {

    /**
     * 删除存在的起订量
     *
     * @param onlyKeys
     * @author: huojia
     * @date: 2021/1/26 9:52
     * @return: void
     */
    void deleteAllByOnlyKeyIn(List<String> onlyKeys);

    /**
     * 根据id的list集合获取起订量信息
     *
     * @param ids
     * @author: huojia
     * @date: 2021/1/26 14:13
     * @return: java.util.List<com.biz.crm.order.entity.MinOrderEntity>
     */
    List<MinBuyNumOfProductEntity> findAllByIdIn(List<String> ids);

    /**
     * 根据id获取起订量
     *
     * @param id
     * @author: huojia
     * @date: 2021/1/27 15:00
     * @return: com.biz.crm.order.entity.MinOrderEntity
     */
    MinBuyNumOfProductEntity findAllById(String id);

    /**
     * 根据id批量删除
     *
     * @param ids
     * @author: huojia
     * @date: 2021/1/26 15:21
     * @return: void
     */
    void deleteAllByIdIn(List<String> ids);

    /**
     * 根据客户编码查询列表
     * @param cusCode 客户编码
     * @param effectiveCode
     * @return
     */
    List<MinBuyNumOfProductEntity> findByCusCodeAndEffectiveFlag(String cusCode, Integer effectiveCode);

    /**
     * 根据组织编码查询列表
     * @param orgCode  组织编码
     * @param effectiveCode
     * @return
     */
    List<MinBuyNumOfProductEntity> findByOrgCodeAndEffectiveFlag(String orgCode, Integer effectiveCode);
}
