package com.biz.crm.notice.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;



import javax.persistence.Index;


/**
 * @Description:公告
 * @Author: zhangyuzhu
 * @Date: 2020/9/11 15:43
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_notice")
@CrmTable(name = "dms_notice", indexes = {
        @Index(name = "index_publish_org_code", columnList = "publish_org_code")
},tableNote = "公告")
public class NoticeEntity extends CrmExtTenEntity<NoticeEntity> {

    /**
     * 标题
     */
    @CrmColumn(name = "title")
    private String title;

    /**
     * 类型
     */
    @CrmColumn(name = "type")
    private Integer type;

    /**
     * 发布部门code
     */
    @CrmColumn(name = "publish_org_code", length = 64)
    private String publishOrgCode;

    /**
     * 发布部门名称
     */
    @CrmColumn(name = "publish_org_name", length = 100)
    private String publishOrgName;


    /**
     * 生效开始时间(yyyy-MM-dd hh:mm:ss)
     */
    @CrmColumn(name = "start_time", length = 20)
    private String startTime;


    /**
     * 生效结束时间(yyyy-MM-dd hh:mm:ss)
     */
    @CrmColumn(name = "end_time", length = 20)
    private String endTime;


    /**
     * 访问人数
     */
    @CrmColumn(name = "visit_num")
    private Integer visitNum;


    /**
     * 公告内容
     */
    @CrmColumn(name = "content", length = 4000)
    private String content;
}
