package com.biz.crm.notice.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;



import javax.persistence.Index;


/**
 * @Description:公告访问记录
 * @Author: heyijiang
 * @Date: 2020/9/24 18:04
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_notice_visited_log")
@CrmTable(name = "dms_notice_visited_log", indexes = {
        @Index(name = "notice_visited_log_id", columnList = "notice_id")
},tableNote = "公告访问记录")
public class NoticeVisitedLogEntity extends CrmExtEntity<NoticeVisitedLogEntity> {

    /**
     * 公告ID
     */
    @CrmColumn(name = "notice_id", length = 64)
    private String noticeId;

    /**
     * 客户编码
     */
    @CrmColumn(name = "cus_code", length = 64)
    private String cusCode;

    /**
     * 客户名字
     */
    @CrmColumn(name = "cus_name", length = 100)
    private String cusName;
}
