package com.biz.crm.notice.service;

import com.biz.crm.nebular.dms.notice.NoticeFileVo;
import com.biz.crm.notice.entity.NoticeEntity;

import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/11 16:42
 **/
public interface NoticeFileService {

    /**
     * 根据公告，批量保存文件
     * @param noticeEntity
     * @param files
     */
    void replace(NoticeEntity noticeEntity, List<NoticeFileVo> files);


    /**
     * 根据公告id查询文件信息(按照文件序号排序)
     * @param noticeId
     * @return
     */
    List<NoticeFileVo> findByNoticeId(String noticeId);

    /**
     * 根据公告ids查询文件信息(按照文件序号排序)
     * @param noticeIds
     * @return
     */
    Map<String, List<NoticeFileVo>> findByNoticeIds(List<String> noticeIds);

    /**
     * 根据公告id批量删除
     * @param noticeIds
     * @return
     */
    void delByNoticeIds(List<String> noticeIds);
}
