package com.biz.crm.notice.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.notice.ListReq;
import com.biz.crm.nebular.dms.notice.ListRes;
import com.biz.crm.nebular.dms.notice.NoticeVo;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/11 16:42
 **/
public interface NoticeService {

    /**
     * 新增
     * @param noticeVo
     */
    void add(NoticeVo noticeVo);

    /**
     * 编辑
     * @param noticeVo
     */
    void edit(NoticeVo noticeVo);

    /**
     * 通过id查询对象
     * @param id
     * @return
     */
    NoticeVo findById(String id);


    /**
     * 分页搜索
     * @param noticeVo
     * @return
     */
    PageResult<NoticeVo> list(NoticeVo noticeVo);

    /**
     * 分页搜索
     * @param listReq 管理端以外的端的参数
     * @return
     */
    PageResult<ListRes> listByUser(ListReq listReq, List<String> orgCodes);


    /**
     * 根据id批量删除或者恢复
     * @param ids
     */
    void delByIds(ArrayList<String> ids);

    /**
     * 根据查询条件批量删除
     * @param noticeVo
     */
    void delByParam(NoticeVo noticeVo);

    /**
     * 指定公告数量+1
     * @param noticeId
     */
    void updateVisitNum(String noticeId);

    /**
     * 根据id列表查询
     * @param ids
     * @return
     */
    List<NoticeVo> findByIds(List<String> ids);
}
