package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.notice.NoticeAreaVo;
import com.biz.crm.notice.entity.NoticeAreaEntity;
import com.biz.crm.notice.entity.NoticeEntity;
import com.biz.crm.notice.mapper.NoticeAreaMapper;
import com.biz.crm.notice.service.NoticeAreaService;
import com.biz.crm.notice.utils.NoticeAreaUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/11 16:47
 **/
@ConditionalOnMissingBean(name = "noticeAreaServiceExpandImpl")
@Service(value = "noticeAreaService")
public class NoticeAreaServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<NoticeAreaMapper, NoticeAreaEntity> implements NoticeAreaService {

    @Autowired
    private NoticeAreaMapper noticeAreaMapper;

    /**
     * 1、先删除公告下的所有范围
     * 2、组装
     * 3、保存
     * @param noticeEntity
     * @param areaVos
     */
    @Transactional
    @Override
    public void replace(NoticeEntity noticeEntity, List<NoticeAreaVo> areaVos) {
        //1
        this.removeByMap(new HashMap<String, Object>(){{
            put("notice_id",noticeEntity.getId());
        }});
        //如果没有区域，则代表该公告暂时不发布
        if(CollectionUtils.isEmpty(areaVos)){
            return;
        }

        //2
        List<NoticeAreaEntity> entities = new ArrayList<>();
        for(NoticeAreaVo vo:areaVos){
            NoticeAreaEntity entity = new NoticeAreaEntity();
            BeanUtils.copyProperties(vo,entity);
            entity.setNoticeId(noticeEntity.getId());
            entities.add(entity);
        }
        entities = NoticeAreaUtil.judegeOffsetFlag(entities);

        //3
        this.saveBatch(entities);
    }

    /**
     * 1、验证
     * 2、查询并且组装返回
     * @param noticeId
     * @return
     */
    @Override
    public List<NoticeAreaVo> findByNoticeId(String noticeId) {
        //1
        if(StringUtils.isEmpty(noticeId)){
            return new ArrayList<>();
        }

        //2
        QueryWrapper<NoticeAreaEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("notice_id", noticeId);
        List<NoticeAreaEntity> areaEntities = noticeAreaMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(areaEntities)){
            return new ArrayList<>();
        }
        List<NoticeAreaVo> reList = new ArrayList<>(areaEntities.size());
        for(NoticeAreaEntity entity : areaEntities){
            NoticeAreaVo vo = new NoticeAreaVo();
            BeanUtils.copyProperties(entity,vo);
            reList.add(vo);
        }
        return reList;
    }

    @Override
    @Transactional
    public void delByNoticeIds(List<String> noticeIds) {
        if(CollectionUtils.isEmpty(noticeIds)){
            throw new BusinessException("公告id为空");
        }
        QueryWrapper<NoticeAreaEntity> wrapper = new QueryWrapper<>();
        wrapper.in("notice_id", noticeIds);
        noticeAreaMapper.delete(wrapper);
    }
}
