package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.notice.NoticeFileVo;
import com.biz.crm.notice.entity.NoticeEntity;
import com.biz.crm.notice.entity.NoticeFileEntity;
import com.biz.crm.notice.mapper.NoticeFileMapper;
import com.biz.crm.notice.service.NoticeFileService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/11 16:45
 **/
@ConditionalOnMissingBean(name = "noticeFileServiceExpandImpl")
@Service(value = "noticeFileService")
public class NoticeFileServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<NoticeFileMapper, NoticeFileEntity> implements NoticeFileService {

    @Autowired
    private NoticeFileMapper noticeFileMapper;

    /**
     * 1、先删除公告下的所有文件
     * 2、组装
     * 3、保存
     * @param noticeEntity
     * @param files
     */
    @Transactional
    @Override
    public void replace(NoticeEntity noticeEntity, List<NoticeFileVo> files) {
        //1
        this.removeByMap(new HashMap<String, Object>(){{
            put("notice_id",noticeEntity.getId());
        }});
        if(CollectionUtils.isEmpty(files)){
            return;
        }

        //2
        List<NoticeFileEntity> entities = new ArrayList<>(files.size());
        int i = 0;
        for(NoticeFileVo vo : files){
            i ++ ;
            vo.setSortNum(i);
            NoticeFileEntity entity = new NoticeFileEntity();
            BeanUtils.copyProperties(vo,entity);
            entity.setNoticeId(noticeEntity.getId());
            entities.add(entity);
        }

        //3
        this.saveBatch(entities);
    }

    /**
     * 1、验证
     * 2、查询并且组装返回
     * @param noticeId
     * @return
     */
    @Override
    public List<NoticeFileVo> findByNoticeId(String noticeId) {
        //1
        if(StringUtils.isEmpty(noticeId)){
            return new ArrayList<>();
        }

        //2
        QueryWrapper<NoticeFileEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("notice_id", noticeId);
        List<NoticeFileEntity> fileEntities = noticeFileMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(fileEntities)){
            return new ArrayList<>();
        }
        List<NoticeFileVo> reList = new ArrayList<>(fileEntities.size());
        for(NoticeFileEntity entity : fileEntities){
            NoticeFileVo vo = new NoticeFileVo();
            BeanUtils.copyProperties(entity,vo);
            reList.add(vo);
        }
        Collections.sort(reList,(a, b)->a.getSortNum().compareTo(b.getSortNum()));
        return reList;
    }

    /**
     * 1、验证
     * 2、查询并且组装
     * 3、排序并返回
     * @param noticeIds
     * @return
     */
    @Override
    public Map<String, List<NoticeFileVo>> findByNoticeIds(List<String> noticeIds) {
        //1
        Map<String, List<NoticeFileVo>> reMap = new HashMap<>();
        if(CollectionUtils.isEmpty(noticeIds)){
            return reMap;
        }

        //2
        QueryWrapper<NoticeFileEntity> wrapper = new QueryWrapper<>();
        wrapper.in("notice_id", noticeIds);
        List<NoticeFileEntity> fileEntities = noticeFileMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(fileEntities)){
            return reMap;
        }
        reMap = fileEntities.stream()
                .map(entity->{
                    NoticeFileVo vo = new NoticeFileVo();
                    BeanUtils.copyProperties(entity, vo);
                    return vo;
                })
                .collect(Collectors.groupingBy(NoticeFileVo::getNoticeId));

        //3
        for(String informationId : reMap.keySet()){
            Collections.sort(reMap.get(informationId), (a,b)->a.getSortNum().compareTo(b.getSortNum()));
        }
        return reMap;
    }

    @Override
    @Transactional
    public void delByNoticeIds(List<String> noticeIds) {
        if(CollectionUtils.isEmpty(noticeIds)){
            throw new BusinessException("公告id为空");
        }
        QueryWrapper<NoticeFileEntity> wrapper = new QueryWrapper<>();
        wrapper.in("notice_id", noticeIds);
        noticeFileMapper.delete(wrapper);
    }
}
