package com.biz.crm.notice.utils;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.dms.notice.NoticeAreaVo;
import com.biz.crm.nebular.dms.notice.NoticeVo;
import com.biz.crm.notice.entity.NoticeAreaEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/14 15:04
 **/
public class NoticeAreaUtil {

    /**
     * 设置抵消标志
     * @param entities
     * @return
     */
    public static List<NoticeAreaEntity> judegeOffsetFlag(List<NoticeAreaEntity> entities){
        if(CollectionUtils.isEmpty(entities)){
            return new ArrayList<>();
        }
        List<NoticeAreaEntity> containEntities = entities.stream().filter(
                entitiy -> entitiy.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()
        ).collect(Collectors.toList());
        List<NoticeAreaEntity> nonContainEntities = entities.stream().filter(
                entitiy -> entitiy.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue()
        ).collect(Collectors.toList());
        for(NoticeAreaEntity entity : containEntities){
            entity.setOffsetFlag(YesNoEnum.YesNoCodeNumberEnum.NO.getCode());
            if(judegeFromNonContain(nonContainEntities,entity)){
                entity.setOffsetFlag(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
            }
        }
        for(NoticeAreaEntity entity : nonContainEntities){
            entity.setOffsetFlag(YesNoEnum.YesNoCodeNumberEnum.NO.getCode());
        }
        List<NoticeAreaEntity> reList = new ArrayList<>(entities.size());
        reList.addAll(containEntities);
        reList.addAll(nonContainEntities);
        return reList;
    }

    /**
     * 判断是否能被抵消 为judgeOffsetFlag方法的附属方法
     * @param nonContainEntities
     * @param entity
     * @return
     */
    public static boolean judegeFromNonContain(List<NoticeAreaEntity> nonContainEntities,NoticeAreaEntity entity){
        if(CollectionUtils.isEmpty(nonContainEntities)){
            return false;
        }
        for(NoticeAreaEntity noEntity : nonContainEntities){
            if(!StringUtils.isEmpty(noEntity.getOrgCode()) && !StringUtils.isEmpty(entity.getOrgCode())
                && noEntity.getOrgCode().equals(entity.getOrgCode())){
                return true;
            }
            if(!StringUtils.isEmpty(noEntity.getCusCode()) && !StringUtils.isEmpty(entity.getCusCode())
                    && noEntity.getCusCode().equals(entity.getCusCode())){
                return true;
            }
        }
        return false;
    }


    /**
     * 将所有的区域组装成一起
     * @param noticeVo
     * @return
     */
    public static List<NoticeAreaVo> addAllAreas(NoticeVo noticeVo){
        List<NoticeAreaVo> areaVos = new ArrayList<>();
        if(!CollectionUtils.isEmpty(noticeVo.getOrgs())){
            areaVos.addAll(noticeVo.getOrgs());
        }
        if(!CollectionUtils.isEmpty(noticeVo.getNonOrgs())){
            areaVos.addAll(noticeVo.getNonOrgs());
        }
        if(!CollectionUtils.isEmpty(noticeVo.getCustomers())){
            areaVos.addAll(noticeVo.getCustomers());
        }
        if(!CollectionUtils.isEmpty(noticeVo.getNonCustomers())){
            areaVos.addAll(noticeVo.getNonCustomers());
        }
        return areaVos;
    }


    /**
     * 区分区域（如果没有则用空集合代替）
     * org->组织包含；nonOrg->组织非包含 customer->客户包含 nonCustomer->客户非包含
     * @param areaVos
     * @return
     */
    public static Map<String, List<NoticeAreaVo>> distArea(List<NoticeAreaVo> areaVos){
        Map<String,List<NoticeAreaVo>> areaMap = new HashMap<>();
        List<NoticeAreaVo> blankList = new ArrayList<>();
        areaMap.put("org",blankList);
        areaMap.put("nonOrg",blankList);
        areaMap.put("customer",blankList);
        areaMap.put("nonCustomer",blankList);
        if(CollectionUtils.isEmpty(areaVos)) {
            return areaMap;
        }
        List<NoticeAreaVo> org = areaVos.stream()
                .filter(
                        areaVo -> !StringUtils.isEmpty(areaVo.getOrgCode())
                                && areaVo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()
                ).collect(Collectors.toList());

        List<NoticeAreaVo> nonOrg = areaVos.stream()
                .filter(
                        areaVo -> !StringUtils.isEmpty(areaVo.getOrgCode())
                                && areaVo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue()
                ).collect(Collectors.toList());

        List<NoticeAreaVo> customer = areaVos.stream()
                .filter(
                        areaVo -> !StringUtils.isEmpty(areaVo.getCusCode())
                                && areaVo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()
                ).collect(Collectors.toList());

        List<NoticeAreaVo> nonCustomer = areaVos.stream()
                .filter(
                        areaVo -> !StringUtils.isEmpty(areaVo.getCusCode())
                                && areaVo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue()
                ).collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(org)){
            areaMap.put("org",org);
        }
        if(!CollectionUtils.isEmpty(nonOrg)){
            areaMap.put("nonOrg",nonOrg);
        }
        if(!CollectionUtils.isEmpty(customer)){
            areaMap.put("customer",customer);
        }
        if(!CollectionUtils.isEmpty(nonCustomer)){
            areaMap.put("nonCustomer",nonCustomer);
        }
        return areaMap;
    }
}
