package com.biz.crm.notice.utils;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.dms.NoticeEunm;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/14 15:04
 **/
public class NoticeUtil {


    /**
     * 转换公告状态
     * @param startDate
     * @param endDate
     * @return
     */
    public static int transState(String startDate,String endDate){
        if(StringUtils.isEmpty(startDate) || StringUtils.isEmpty(endDate)){
            throw new BusinessException("公告开始时间和结束时间为空!");
        }
        long start = DateUtil.str2Date(startDate, DateUtil.datetimeFormat).getTime();
        long end = DateUtil.str2Date(endDate,DateUtil.datetimeFormat).getTime();
        long now = DateUtil.getDate().getTime();
        if(now < start){
            return NoticeEunm.NoticeStateEunm.TOBEGIN.getCode();
        }
        if(now > end){
            return NoticeEunm.NoticeStateEunm.FINISHED.getCode();
        }
        return NoticeEunm.NoticeStateEunm.ONGOING.getCode();
    }
}
