package com.biz.crm.order.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.order.service.OrderService;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;

@Api(value = "微信端-订单", tags = "微信端-订单")
@RestController
@RequestMapping(value = "/v/order")
public class OrdervController {

    @Resource
    private OrderService orderService;


    @CrmLog
    @ApiOperation(value = "算价")
    @PostMapping(value = "cal")
    public Result<OrderVo> cal(@RequestBody OrderVo orderVo) {
        OrderVo reVo =  orderService.cal(orderVo,false);
        return Result.ok(reVo);
    }

    @CrmLog
    @ApiOperation(value = "暂存")
    @PostMapping(value = "/temporary/add")
    public Result temporaryAdd(@RequestBody OrderVo orderVo) {
        orderService.temporaryAdd(orderVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "保存订单")
    @PostMapping(value = "/add")
    public Result add(@RequestBody OrderVo orderVo) {
        orderService.add(orderVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "编辑订单")
    @PostMapping(value = "/edit")
    public Result edit(@RequestBody OrderVo orderVo) {
        orderService.edit(orderVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "取消订单（退单）")
    @PostMapping(value = "cancelByIds")
    public Result cancelByIds(@RequestBody ArrayList<String> ids) {
        orderService.cancel(ids);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "通过条件分页查询")
    @PostMapping(value = "listByConditions")
    public Result listByConditions(@RequestBody OrderVo orderVo) {
        UserRedis user = UserUtils.getUser();
        ValidateUtils.validate(user, "没有获取到当前登录用户");
        ValidateUtils.validate(user.getCustcode(), "没有获取到当前登录客户编码，请确认是否正确访问");
        orderVo.setCusCode(user.getCustcode());
        return Result.ok(orderService.listByConditions(orderVo));
    }

    @CrmLog
    @ApiOperation(value = "根据id查询订单详情")
    @GetMapping(value = "findDetailsById/{id}")
    public Result<OrderVo> findDetailsById(@PathVariable(name = "id") String id) {
        OrderVo result = this.orderService.findDetailsById(id);
        return Result.ok(result);
    }

    @CrmLog
    @ApiOperation(value = "批量删除订单")
    @PostMapping(value = "deleteByIds")
    public Result deleteByIds(@RequestBody List<String> ids) {
        this.orderService.deleteByIds(ids);
        return Result.ok();
    }

    @ApiOperation(value = "根据id查询订单详情(不询价)")
    @GetMapping(value = "findSimpleDetailsById/{id}")
    public Result<OrderVo> findSimpleDetailsById(@PathVariable(name = "id") String id) {
        OrderVo result = this.orderService.findSimpleDetailsById(id);
        return Result.ok(result);
    }
}
