package com.biz.crm.order.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/27 16:49
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_order_detail")
@CrmTable(name = "dms_order_detail",tableNote = "订单明细")
public class OrderDetailEntity extends CrmExtEntity<OrderDetailEntity> {

    /**
     * 订单编码
     */
    @CrmColumn(name = "order_code", length = 64)
    private String orderCode;

    /**
     * 行号
     */
    @CrmColumn(name = "line_no", length = 64)
    private String lineNo;

    /**
     * 行项目类型
     */
    @CrmColumn(name = "line_type", length = 64)
    private String lineType;

    /**
     * 商品编码
     */
    @CrmColumn(name = "product_code", length = 64)
    private String productCode;

    /**
     * 商品sap编码(物料编码)
     */
    @CrmColumn(name = "product_sap_code", length = 64)
    private String productSapCode;

    /**
     * 商品名称
     */
    @CrmColumn(name = "product_name", length = 100)
    private String productName;

    /**
     * 规格
     */
    @CrmColumn(name = "spec", length = 64)
    private String spec;

    /**
     * 数量
     */
    @CrmColumn(name = "product_num",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal productNum;

    /**
     * 总重量(克)
     */
    @CrmColumn(name = "weight_of_gram",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal weightOfGram;

    /**
     * 总重量(千克)
     */
    @CrmColumn(name = "weight_of_kilogram",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal weightOfKilogram;

    /**
     * 总重量(吨)
     */
    @CrmColumn(name = "weight_of_ton",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal weightOfTon;

    /**
     * 销售单位编码
     */
    @CrmColumn(name = "sales_unit", length = 64)
    private String salesUnit;

    /**
     * 销售单位名称
     */
    @CrmColumn(name = "sales_unit_name", length = 100)
    private String salesUnitName;

    /**
     * 单价
     */
    @CrmColumn(name = "price",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal price;

    /**
     * 本行总金额
     */
    @CrmColumn(name = "amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal amount;

    /**
     * 分组编码
     */
    @CrmColumn(name = "group_code", length = 64)
    private String groupCode;

    /**
     * 促销编码
     */
    @CrmColumn(name = "promotion_policy_code", length = 64)
    private String promotionPolicyCode;

    /**
     * 货补费用池编码
     */
    @CrmColumn(name = "fee_code",length = 64)
    private String feeCode;

    /**
     * 货补费用池名称
     */
    @CrmColumn(name = "fee_name", length = 128)
    private String feeName;

    /**
     * 促销名称
     */
    @CrmColumn(name = "promotion_policy_name", length = 100)
    private String promotionPolicyName;

    /**
     * 默认商品图片
     */
    @CrmColumn(name = "img_url", length = 255)
    private String imgUrl;
}
