package com.biz.crm.order.tools.strategy.calorder.impl;

import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.order.tools.strategy.calorder.CalOrderStrategy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;

/**
 * @Description: 货补订单算总价策略
 * @Author: zhangyuzhu
 * @Date: 2021/3/16 19:47
 **/
@ConditionalOnMissingBean(name = "rebateCalOrderStrategyExpand")
@Component("rebateCalOrderStrategy")
public class RebateCalOrderStrategy implements CalOrderStrategy {


    @Override
    public OrderVo cal(OrderVo orderVo,String cusCode,String orgCode, Object... objects) {
        //订单总金额(不包括 促销优惠价格)
        BigDecimal amount = BigDecimal.ZERO;
        //订单货补费用使用金额
        BigDecimal repAmount = BigDecimal.ZERO;
        for(OrderGroupItemVo orderGroupItemVo : orderVo.getGroupItemVos()){
            if(!CollectionUtils.isEmpty(orderGroupItemVo.getBackList())){
                for(OrderDetailVo item : orderGroupItemVo.getBackList()){
                    repAmount = repAmount.add(item.getAmount());
                    amount = amount.add(item.getAmount());
                }
            }
            if(!CollectionUtils.isEmpty(orderGroupItemVo.getNormalList())){
                for(OrderDetailVo item : orderGroupItemVo.getNormalList()){
                    amount = amount.add(item.getAmount());
                }
            }
        }
        orderVo.setAmount(amount.setScale(2,BigDecimal.ROUND_HALF_UP));
        orderVo.setDiscountAmount(BigDecimal.ZERO);
        orderVo.setPromotionAmount(BigDecimal.ZERO);
        orderVo.setRepAmount(repAmount.setScale(2,BigDecimal.ROUND_HALF_UP));
        orderVo.setActualAmount(BigDecimal.ZERO);
        return orderVo;
    }
}
