package com.biz.crm.order.tools.strategy.completionproductmsg.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseAndPriceReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseAndPriceRespVo;
import com.biz.crm.order.tools.strategy.completionproductmsg.CompletionProductMsgStrategy;
import com.biz.crm.util.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @Description: 货补单补全商品信息
 * @Author: zhangyuzhu
 * @Date: 2021/3/16 17:48
 **/
@ConditionalOnMissingBean(name = "rebateCompletionProductMsgStrategyExpand")
@Component("rebateCompletionProductMsgStrategy")
public class RebateCompletionProductMsgStrategy implements CompletionProductMsgStrategy {

    @Autowired
    private MdmProductFeign mdmProductFeign;

    @Override
    public OrderVo completion(OrderVo orderVo,String cusCode,String orgCode, Object... objects) {
        List<String> productCode  = this.extractProductCodes(orderVo);
        Result<Map<String, MdmProductAdviseAndPriceRespVo>> result = mdmProductFeign.queryByProductCodeAndCus(
                MdmProductAdviseAndPriceReqVo.newInstanceForSalePrice(cusCode,orgCode,productCode)
        );
        if(!result.isSuccess()){
            throw new BusinessException("商品服务正在重启，请联系管理员");
        }
        Map<String, MdmProductAdviseAndPriceRespVo> productMap =result.getResult();
        orderVo = this.packageProductMsg(orderVo,productMap);
        return orderVo;
    }

    /**
     * 补全产品信息
     * @param orderVo
     * @param productMsp
     * @return
     */
    public OrderVo packageProductMsg(OrderVo orderVo,Map<String, MdmProductAdviseAndPriceRespVo> productMsp){
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            this.packageGroup(orderVo,groupItemVo,productMsp);
        }
        return orderVo;
    }

    /**
     * 补全产品信息(行)
     * @param orderVo
     * @param groupItemVo
     * @param productMsp
     */
    public void packageGroup(OrderVo orderVo,OrderGroupItemVo groupItemVo,Map<String, MdmProductAdviseAndPriceRespVo> productMsp){
        if(!CollectionUtils.isEmpty(groupItemVo.getBackList())){
            List<OrderDetailVo> backList = new ArrayList<>();
            for(OrderDetailVo item : groupItemVo.getBackList()){
                MdmProductAdviseAndPriceRespVo product = productMsp.get(item.getProductCode());
                if(null == product){
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb = new StringBuilder("提示：商品【")
                            .append(item.getProductName())
                            .append("】已经下架！");
                    item.setCalSucessMsg(stb.toString());
                }else {
                    if(null == product.getSalePrice()){
                        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                        item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        StringBuilder stb = new StringBuilder("提示：商品【")
                                .append(item.getProductName())
                                .append("】未维护价格，请联系管理员！");
                        item.setCalSucessMsg(stb.toString());
                    }
                    this.packageItemVo(item,product);
                }
                backList.add(item);
            }
            groupItemVo.setBackList(backList);
        }
    }

    /**
     * 组装vo信息
     * @param item
     * @param product
     * @return
     */
    public OrderDetailVo packageItemVo(OrderDetailVo item, MdmProductAdviseAndPriceRespVo product){
        item.setProductName(product.getProductName());
        item.setSpec(product.getSpec());
        item.setSalesUnit(product.getSaleUnit());
        item.setSalesUnitName(product.getSaleUnitName());
        item.setPrice(product.getSalePrice());
        item.setProductLevelCode(product.getProductLevelCode());
        return item;
    }


    /**
     * 提取货补产品编码
     * @param orderVo
     * @return key -> nomal 本品；other 本品之外的所有
     */
    public List<String> extractProductCodes(OrderVo orderVo){
        Set<String> set = new HashSet<>();
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(!CollectionUtils.isEmpty(groupItemVo.getBackList())){
                for(OrderDetailVo item : groupItemVo.getBackList()){
                    set.add(item.getProductCode());
                }
            }
        }
        return new ArrayList<>(set);
    }

}
