package com.biz.crm.order.tools.strategy.completionproductmsg.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.mdm.availablelist.AvailableListFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.nebular.mdm.availablelist.CusAvailablelistVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseAndPriceReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseAndPriceRespVo;
import com.biz.crm.order.tools.strategy.completionproductmsg.CompletionProductMsgStrategy;
import com.biz.crm.util.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @Description: 标准单补全商品信息
 * @Author: zhangyuzhu
 * @Date: 2021/3/16 17:48
 **/
@ConditionalOnMissingBean(name = "standerdCompletionProductMsgStrategyExpand")
@Component("standerdCompletionProductMsgStrategy")
public class StanderdCompletionProductMsgStrategy implements CompletionProductMsgStrategy {

    @Autowired
    private MdmProductFeign mdmProductFeign;

    @Autowired
    private AvailableListFeign availableListFeign;

    @Override
    public OrderVo completion(OrderVo orderVo,String cusCode,String orgCode, Object... objects) {
        Map<String,List<String>> productCodeMap = this.extractProductCodesToMap(orderVo);
        List<String> otherProductCode = productCodeMap.get("other");
        List<String> nomalProductCode = productCodeMap.get("nomal");


        //本品之外的可以不通过可够清单查询(即没有可够清单的限制)，从mdm查询
        if(!CollectionUtils.isEmpty(otherProductCode)){
            Result<Map<String, MdmProductAdviseAndPriceRespVo>> result = mdmProductFeign.queryByProductCodeAndCus(
                    MdmProductAdviseAndPriceReqVo.newInstanceForSalePrice(cusCode,orgCode,otherProductCode)
            );
            if(!result.isSuccess()){
                throw new BusinessException("商品服务正在重启，请联系管理员");
            }
            Map<String, MdmProductAdviseAndPriceRespVo> productMsp = result.getResult();
            orderVo = this.packageProductMsg(orderVo,productMsp);
            if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
                return orderVo;
            }
        }


        //本品从可够清单查询
        if(!CollectionUtils.isEmpty(nomalProductCode)){
            Result<Map<String, CusAvailablelistVo>> result = availableListFeign.findGoodsByCusAndGoodsCodes(nomalProductCode,cusCode);
            if(!result.isSuccess()){
                throw new BusinessException("商品服务正在重启，请联系管理员");
            }
            Map<String, CusAvailablelistVo> productMap = result.getResult();
            orderVo = this.packageProductMsgForNormal(orderVo,productMap);
        }
        return orderVo;
    }

    /**
     * 补全产品信息(本品)
     * @param orderVo
     * @param productMap
     * @return
     */
    public OrderVo packageProductMsgForNormal(OrderVo orderVo, Map<String, CusAvailablelistVo> productMap){
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            this.packageGroupForNormal(orderVo,groupItemVo,productMap);
        }
        return orderVo;
    }

    /**
     * 补全产品信息(本品)(行)
     * @param orderVo
     * @param groupItemVo
     * @param productMap
     */
    public void packageGroupForNormal(OrderVo orderVo,OrderGroupItemVo groupItemVo,Map<String, CusAvailablelistVo> productMap){
        if(!CollectionUtils.isEmpty(groupItemVo.getNormalList())){
            List<OrderDetailVo> normalList = new ArrayList<>();
            for(OrderDetailVo item : groupItemVo.getNormalList()){
                CusAvailablelistVo product = productMap.get(item.getProductCode());
                if(null == product){
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb = new StringBuilder("提示：商品【")
                            .append(item.getProductName())
                            .append("】已经下架！");
                    item.setCalSucessMsg(stb.toString());
                }else {
                    if(null == product.getPrice()){
                        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                        item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        StringBuilder stb = new StringBuilder("提示：商品【")
                                .append(item.getProductName())
                                .append("】未维护价格，请联系管理员！");
                        item.setCalSucessMsg(stb.toString());
                    }
                    this.packageItemVoForNormal(item,product);
                }
                normalList.add(item);
            }
            groupItemVo.setNormalList(normalList);
        }
    }

    /**
     * 组装vo信息(本品)
     * @param item
     * @param product
     * @return
     */
    public OrderDetailVo packageItemVoForNormal(OrderDetailVo item, CusAvailablelistVo product){
        item.setProductName(product.getProductName());
        item.setSpec(product.getSpec());
        item.setSalesUnit(product.getSaleUnit());
        item.setSalesUnitName(product.getSaleUnitName());
        item.setPrice(product.getPrice());
        item.setProductLevelCode(product.getProductLevelCode());
        return item;
    }



    /**
     * 补全产品信息(赠品 + 货补)
     * @param orderVo
     * @param productMsp
     * @return
     */
    public OrderVo packageProductMsg(OrderVo orderVo,Map<String, MdmProductAdviseAndPriceRespVo> productMsp){
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            this.packageGroup(orderVo,groupItemVo,productMsp);
        }
        return orderVo;
    }

    /**
     * 补全产品信息(行)(赠品 + 货补)
     * @param orderVo
     * @param groupItemVo
     * @param productMsp
     */
    public void packageGroup(OrderVo orderVo,OrderGroupItemVo groupItemVo,Map<String, MdmProductAdviseAndPriceRespVo> productMsp){
        if(!CollectionUtils.isEmpty(groupItemVo.getBackList())){
            List<OrderDetailVo> backList = new ArrayList<>();
            for(OrderDetailVo item : groupItemVo.getBackList()){
                MdmProductAdviseAndPriceRespVo product = productMsp.get(item.getProductCode());
                if(null == product){
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb = new StringBuilder("提示：商品【")
                            .append(item.getProductName())
                            .append("】已经下架！");
                    item.setCalSucessMsg(stb.toString());
                }else {
                    if(null == product.getSalePrice()){
                        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                        item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        StringBuilder stb = new StringBuilder("提示：商品【")
                                .append(item.getProductName())
                                .append("】未维护价格，请联系管理员！");
                        item.setCalSucessMsg(stb.toString());
                    }
                    this.packageItemVo(item,product);
                }
                backList.add(item);
            }
            groupItemVo.setBackList(backList);
        }

        if(!CollectionUtils.isEmpty(groupItemVo.getGiftList())){
            List<OrderDetailVo> giftList = new ArrayList<>();
            for(OrderDetailVo item : groupItemVo.getGiftList()){
                MdmProductAdviseAndPriceRespVo product = productMsp.get(item.getProductCode());
                if(null == product){
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb = new StringBuilder("提示：商品【")
                            .append(item.getProductName())
                            .append("】已经下架！");
                    item.setCalSucessMsg(stb.toString());
                }else {
                    if(null == product.getSalePrice()){
                        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                        item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        StringBuilder stb = new StringBuilder("提示：商品【")
                                .append(item.getProductName())
                                .append("】未维护价格，请联系管理员！");
                        item.setCalSucessMsg(stb.toString());
                    }
                    this.packageItemVo(item,product);
                }
                giftList.add(item);
            }
            groupItemVo.setGiftList(giftList);
        }
    }

    /**
     * 组装vo信息(赠品 + 货补)
     * @param item
     * @param product
     * @return
     */
    public OrderDetailVo packageItemVo(OrderDetailVo item, MdmProductAdviseAndPriceRespVo product){
        item.setProductName(product.getProductName());
        item.setSpec(product.getSpec());
        item.setSalesUnit(product.getSaleUnit());
        item.setSalesUnitName(product.getSaleUnitName());
        item.setPrice(product.getSalePrice());
        item.setProductLevelCode(product.getProductLevelCode());
        return item;
    }


    /**
     * 提取产品编码
     * @param orderVo
     * @return key -> nomal 本品；other 本品之外的所有
     */
    public Map<String, List<String>> extractProductCodesToMap(OrderVo orderVo){
        Set<String> normalSet = new HashSet<>();
        Set<String> otherSet = new HashSet<>();
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(!CollectionUtils.isEmpty(groupItemVo.getBackList())){
                for(OrderDetailVo item : groupItemVo.getBackList()){
                    otherSet.add(item.getProductCode());
                }
            }
            if(!CollectionUtils.isEmpty(groupItemVo.getGiftList())){
                for(OrderDetailVo item : groupItemVo.getGiftList()){
                    otherSet.add(item.getProductCode());
                }
            }
            if(!CollectionUtils.isEmpty(groupItemVo.getNormalList())){
                for(OrderDetailVo item : groupItemVo.getNormalList()){
                    normalSet.add(item.getProductCode());
                }
            }
        }
        Map<String,List<String>> reMap = new HashMap<>();
        reMap.put("nomal",new ArrayList<>(normalSet));
        reMap.put("other",new ArrayList<>(otherSet));
        return reMap;
    }
}
