package com.biz.crm.order.utils;

import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import com.biz.crm.order.entity.OrderDetailEntity;
import com.biz.crm.order.entity.OrderEntity;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/3/2 15:18
 **/
public class OrderDetailUtil {

    /**
     * 组装订单详情
     * @param orderVo
     * @param orderEntity
     * @return
     */
    public static List<OrderDetailEntity> packageOrderDetails(OrderVo orderVo,OrderEntity orderEntity,boolean removeZreoFlag){
        List<OrderDetailEntity> detailEntities = new ArrayList<>();
        for (OrderGroupItemVo group : orderVo.getGroupItemVos()) {
            String groupCode = group.getGroupCode();
            if(!CollectionUtils.isEmpty(group.getNormalList())){
                for(OrderDetailVo itemVo : group.getNormalList()){
                    if(removeZreoFlag && itemVo.getProductNum().intValue() == 0){
                        continue;
                    }
                    OrderDetailEntity detailEntity = packageSingleOrderDetails(itemVo, orderEntity, groupCode);
                    detailEntity.setLineType(OrderEunm.LineTypeEnum.SOURCE_PRODUCT.getCode());
                    detailEntities.add(detailEntity);
                }
            }
            if(!CollectionUtils.isEmpty(group.getGiftList())){
                for(OrderDetailVo itemVo : group.getGiftList()){
                    if(removeZreoFlag && itemVo.getProductNum().intValue() == 0){
                        continue;
                    }
                    OrderDetailEntity detailEntity = packageSingleOrderDetails(itemVo, orderEntity, groupCode);
                    detailEntity.setLineType(OrderEunm.LineTypeEnum.GIFT_PRODUCT.getCode());
                    detailEntities.add(detailEntity);
                }
            }
            if(!CollectionUtils.isEmpty(group.getBackList())){
                for(OrderDetailVo itemVo : group.getBackList()){
                    if(removeZreoFlag && itemVo.getProductNum().intValue() == 0){
                        continue;
                    }
                    OrderDetailEntity detailEntity = packageSingleOrderDetails(itemVo, orderEntity, groupCode);
                    detailEntity.setLineType(OrderEunm.LineTypeEnum.REP_PRODUCT.getCode());
                    detailEntities.add(detailEntity);
                }
            }
        }
        return detailEntities;
    }


    /**
     * 组装单个订单详情
     * @param itemVo
     * @param orderEntity
     * @param groupCode
     * @return
     */
    public static OrderDetailEntity packageSingleOrderDetails(OrderDetailVo itemVo, OrderEntity orderEntity, String groupCode){
        OrderDetailEntity detailEntity = new OrderDetailEntity();
        BeanUtils.copyProperties(itemVo, detailEntity);
        detailEntity.setId(null);
        detailEntity.setOrderCode(orderEntity.getOrderCode());
        detailEntity.setGroupCode(groupCode);
        return detailEntity;
    }
}
