package com.biz.crm.orderfeerate.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.dms.orderfeerate.*;
import com.biz.crm.orderfeerate.service.OrderFeeRateService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/8 17:37
 **/
@Api(value = "api端-订单费用使用比例", tags = "api端-订单费用使用比例")
@RestController
@RequestMapping("/api/orderfeerate")
public class OrderFeeRateApiController {

    @Resource
    private OrderFeeRateService orderFeeRateService;

    @CrmLog
    @ApiOperation("计算现金折扣最大使用量")
    @PostMapping("calToCash")
    public Result<BigDecimal> calToCash(@RequestBody OrderFeeRateCalToCashVo orderFeeRateCalToCashVo) {
        return Result.ok(orderFeeRateService.calToCash(orderFeeRateCalToCashVo));
    }

    @CrmLog
    @ApiOperation("计算现金折扣最大使用量(返回对象)")
    @PostMapping("calToCashForObj")
    public Result<OrderFeeRateCalToCashResVo> calToCashForObj(@RequestBody OrderFeeRateCalToCashVo orderFeeRateCalToCashVo) {
        return Result.ok(orderFeeRateService.calToCashForObj(orderFeeRateCalToCashVo));
    }

    @CrmLog
    @ApiOperation("计算货补最大使用量")
    @PostMapping("calToRep")
    public Result<Map<String, BigDecimal>> calToRep(@RequestBody OrderFeeRateCalToRepVo orderFeeRateCalToRepVo) {
        return Result.ok(orderFeeRateService.calToRep(orderFeeRateCalToRepVo));
    }

    @CrmLog
    @ApiOperation("计算货补最大使用量（返回对象）")
    @PostMapping("calToRepForObj")
    public Result<Map<String, OrderFeeRateCalToResVo>> calToRepForObj(@RequestBody OrderFeeRateCalToRepVo orderFeeRateCalToRepVo) {
        return Result.ok(orderFeeRateService.calToRepForObj(orderFeeRateCalToRepVo));
    }


    @CrmLog
    @ApiOperation("计算货补+折扣最大使用量")
    @PostMapping("calToRepAndCash")
    public Result<BigDecimal> calToRepAndCash(@RequestBody OrderFeeRateCalToRepAndCashVo orderFeeRateCalToRepAndCashVo) {
        return Result.ok(orderFeeRateService.calToRepAndCash(orderFeeRateCalToRepAndCashVo));
    }
}
