package com.biz.crm.orderfeerate.utils;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderFeeRateEunm;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepProductVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateVo;
import com.biz.crm.orderfeerate.entity.OrderFeeRateEntity;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description:Y
 * @Author: zhangyuzhu
 * @Date: 2021/3/1 11:44
 **/
@Component(value = "orderFeeRateUtil")
@ConditionalOnMissingBean(name = "orderFeeRateUtilExpand")
public class OrderFeeRateUtil {

    //费用池使用比例模式字典code
    public static final String patternDicCode = "order_fee_rate_pattern";

    //费用池使用比例模式(是否使用汇总模式)字典code
    public static final String useTotalDicCode = "useTotal";

    /**
     * 验证参数
     * @param vo
     */
    public void validate(OrderFeeRateVo vo){
        ValidateUtils.validate(vo.getRate(),"使用比例为空!");
        if(vo.getRate().compareTo(BigDecimal.ZERO) < 0 || vo.getRate().compareTo(new BigDecimal(100)) > 0){
            throw new BusinessException("使用比例应该在 0 ~ 100之间，包括0和100");
        }
        ValidateUtils.validate(vo.getFeeType(),"费用池类型为空!");
        ValidateUtils.validate(vo.getDemension(),"维度为空!");
        validateDemension(vo);
    }


    /**
     * 验证维度
     * @param vo
     */
    public void validateDemension(OrderFeeRateVo vo){
        //商品
        if(vo.getDemension().equals(OrderFeeRateEunm.demension.PRODUCT.getCode())){
            ValidateUtils.validate(vo.getProductCode(),"产品编码为空!");
            ValidateUtils.validate(vo.getProductName(),"产品名称为空!");
        }else if(vo.getDemension().equals(OrderFeeRateEunm.demension.PRODUCTLEVEL.getCode())){
            ValidateUtils.validate(vo.getProductLevelCode(),"产品层级编码为空!");
            ValidateUtils.validate(vo.getProductLevelName(),"产品层级名称为空!");
        }else if(vo.getDemension().equals(OrderFeeRateEunm.demension.CUS.getCode())){
            ValidateUtils.validate(vo.getCusCode(),"客户编码为空!");
            ValidateUtils.validate(vo.getCusName(),"客户名称为空!");
        }else if(vo.getDemension().equals(OrderFeeRateEunm.demension.ORG.getCode())){
            ValidateUtils.validate(vo.getOrgCode(),"客户组织编码为空!");
            ValidateUtils.validate(vo.getOrgName(),"客户组织名称为空!");
        }else if(vo.getDemension().equals(OrderFeeRateEunm.demension.ORGPRODUCT.getCode())){
            ValidateUtils.validate(vo.getOrgCode(),"客户组织编码为空!");
            ValidateUtils.validate(vo.getOrgName(),"客户组织名称为空!");
            ValidateUtils.validate(vo.getProductCode(),"产品编码为空!");
            ValidateUtils.validate(vo.getProductName(),"产品名称为空!");
        }else if(vo.getDemension().equals(OrderFeeRateEunm.demension.ORGPRODUCTLEVEL.getCode())){
            ValidateUtils.validate(vo.getOrgCode(),"客户组织编码为空!");
            ValidateUtils.validate(vo.getOrgName(),"客户组织名称为空!");
            ValidateUtils.validate(vo.getProductLevelCode(),"产品层级编码为空!");
            ValidateUtils.validate(vo.getProductLevelName(),"产品层级名称为空!");
        }else if(vo.getDemension().equals(OrderFeeRateEunm.demension.CUSPRODUCT.getCode())){
            ValidateUtils.validate(vo.getCusCode(),"客户编码为空!");
            ValidateUtils.validate(vo.getCusName(),"客户名称为空!");
            ValidateUtils.validate(vo.getProductCode(),"产品编码为空!");
            ValidateUtils.validate(vo.getProductName(),"产品名称为空!");
        }else if(vo.getDemension().equals(OrderFeeRateEunm.demension.CUSPRODUCTLEVEL.getCode())){
            ValidateUtils.validate(vo.getCusCode(),"客户编码为空!");
            ValidateUtils.validate(vo.getCusName(),"客户名称为空!");
            ValidateUtils.validate(vo.getProductLevelCode(),"产品层级编码为空!");
            ValidateUtils.validate(vo.getProductLevelName(),"产品层级名称为空!");
        }
    }

    /**
     * 组装唯一值
     * @param entity
     * @return
     */
     public String packageOnlyKey(OrderFeeRateEntity entity){
         StringBuilder stb = new StringBuilder();
         //费用池类型
         stb.append(entity.getFeeType());
         //商品
         if(entity.getDemension().equals(OrderFeeRateEunm.demension.PRODUCT.getCode())){
             stb.append(entity.getProductCode());
         }else if(entity.getDemension().equals(OrderFeeRateEunm.demension.PRODUCTLEVEL.getCode())){
             stb.append(entity.getProductLevelCode());
         }else if(entity.getDemension().equals(OrderFeeRateEunm.demension.CUS.getCode())){
             stb.append(entity.getCusCode());
         }else if(entity.getDemension().equals(OrderFeeRateEunm.demension.ORG.getCode())){
             stb.append(entity.getOrgCode());
         }else if(entity.getDemension().equals(OrderFeeRateEunm.demension.ORGPRODUCT.getCode())){
             stb.append(entity.getOrgCode()).append(",").append(entity.getProductCode());
         }else if(entity.getDemension().equals(OrderFeeRateEunm.demension.ORGPRODUCTLEVEL.getCode())){
             stb.append(entity.getOrgCode()).append(",").append(entity.getProductLevelCode());
         }else if(entity.getDemension().equals(OrderFeeRateEunm.demension.CUSPRODUCT.getCode())){
             stb.append(entity.getCusCode()).append(",").append(entity.getProductCode());
         }else if(entity.getDemension().equals(OrderFeeRateEunm.demension.CUSPRODUCTLEVEL.getCode())){
             stb.append(entity.getCusCode()).append(",").append(entity.getProductLevelCode());
         }
         return stb.toString();
     }

    /**
     * 判断模式
     */
    public static void validatePattern(OrderFeeRateVo orderFeeRateVo,String useTotal){
        if(StringUtils.isEmpty(useTotal) || YesNoEnum.yesNoEnum.NO.getValue().equals(useTotal)){
            if(orderFeeRateVo.getFeeType().equals(OrderFeeRateEunm.feeTypeEunm.TOTAL.getCode())){
                throw new BusinessException("暂时不支持汇总模式！");
            }
        }else {
            if(!orderFeeRateVo.getFeeType().equals(OrderFeeRateEunm.feeTypeEunm.TOTAL.getCode())){
                throw new BusinessException("暂时只支持汇总模式！");
            }
        }
    }


    /**
     * calToRep方法的验证
     * @param vo
     */
    public static void validateForCalToRep(OrderFeeRateCalToRepVo vo){
        ValidateUtils.validate(vo.getCusCode(),"客户编码为空!");
        ValidateUtils.validate(vo.getOrgCode(),"客户组织为空");
        ValidateUtils.validate(vo.getOrderMoney(),"订单金额为空");
        for(OrderFeeRateCalToRepProductVo productVo : vo.getProducts()){
            if(StringUtils.isEmpty(productVo.getProductCode())
            || StringUtils.isEmpty(productVo.getProductLevelCode())){
                throw new BusinessException("产品信息不完整!");
            }
        }
    }


    /**
     * 过滤出指定产品或者产品层级的费率
     * @param rates
     * @param product
     * @return
     */
    public static List<OrderFeeRateEntity> filterRate(List<OrderFeeRateEntity> rates,OrderFeeRateCalToRepProductVo product){
        if(CollectionUtils.isEmpty(rates)){
            return new ArrayList<>();
        }
        List<OrderFeeRateEntity> reList = new ArrayList<>();
        for(OrderFeeRateEntity entity : rates){
            //组织或者客户维度
            if(StringUtils.isEmpty(entity.getProductCode()) && StringUtils.isEmpty(entity.getProductLevelCode())){
                reList.add(entity);
            }
            //带了商品或者商品层级的维度
            if((!StringUtils.isEmpty(entity.getProductCode()) && entity.getProductCode().equals(product.getProductCode()))
                    || (!StringUtils.isEmpty(entity.getProductLevelCode()) && entity.getProductLevelCode().equals(product.getProductLevelCode()))
            ){
                reList.add(entity);
            }
        }
        return reList;
    }
}
