package com.biz.crm.promotion.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.dms.promotion.policy.req.DmsPromotionPolicyOrderDetailReqVo;
import com.biz.crm.promotion.service.IDmsPromotionPolicyOrderDetailService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 促销政策订单明细
 *
 * @author lf
 * @date 2020-12-26 13:34:30
 */
@Slf4j
@RestController
@RequestMapping("/dmsPromotionPolicyOrderDetailController")
@Api(tags = "促销政策订单明细")
public class DmsPromotionPolicyOrderDetailController {
    @Autowired
    private IDmsPromotionPolicyOrderDetailService dmsPromotionPolicyOrderDetailService;



    /**
     * 锁定促销政策使用明细
     * @param reqVoList
     * @return
     */
//    @ApiOperation(value = "锁定促销政策使用明细")
//    @PostMapping("lockPromotionPolicyOrderDetailList")
//    @CrmLog
//    public Result<Boolean> lockPromotionPolicyOrderDetailList(@RequestBody List<DmsPromotionPolicyOrderDetailReqVo> reqVoList){
//        Result result = new Result();
//        Boolean flag = dmsPromotionPolicyOrderDetailService.lockPromotionPolicyOrderDetailList(reqVoList);
//        result.setResult(flag);
//        return result;
//    }

    /**
     * 锁定促销政策使用明细
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "锁定促销政策使用明细")
    @PostMapping("lockPromotionPolicyOrderDetail")
    @CrmLog
    public Result<Boolean> lockPromotionPolicyOrderDetail(@RequestBody DmsPromotionPolicyOrderDetailReqVo reqVo){
        Result result = new Result();
        Boolean flag = dmsPromotionPolicyOrderDetailService.lockPromotionPolicyOrderDetail(reqVo);
        result.setResult(flag);
        return result;
    }

    /**
     * 批量锁定促销政策使用明细
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "批量锁定促销政策使用明细")
    @PostMapping("lockPromotionPolicyOrderDetailBatch")
    @CrmLog
    public Result<Boolean> lockPromotionPolicyOrderDetailBatch(@RequestBody List<DmsPromotionPolicyOrderDetailReqVo> reqVo){
        Result result = new Result();
        Boolean flag = dmsPromotionPolicyOrderDetailService.lockPromotionPolicyOrderDetailBatch(reqVo);
        result.setResult(flag);
        return result;
    }

    /**
     * 提交促销政策使用明细
     * @param orderNo
     * @return
     */
    @ApiOperation(value = "提交促销政策使用明细")
    @PostMapping("commitPromotionPolicyOrderDetail")
    @CrmLog
    public Result<Boolean> commitPromotionPolicyOrderDetail(@RequestParam String orderNo){
        Result result = new Result();
        Boolean flag = dmsPromotionPolicyOrderDetailService.commitPromotionPolicyOrderDetail(orderNo);
        result.setResult(flag);
        return result;
    }

    /**
     * 锁定并提交促销政策使用明细
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "锁定并提交促销政策使用明细")
    @PostMapping("lockAndSubmitPromotionPolicyOrderDetail")
    @CrmLog
    public Result<Boolean> lockAndSubmitPromotionPolicyOrderDetail(@RequestBody DmsPromotionPolicyOrderDetailReqVo reqVo){
        Result result = new Result();
        Boolean flag = dmsPromotionPolicyOrderDetailService.lockAndSubmitPromotionPolicyOrderDetail(reqVo);
        result.setResult(flag);
        return result;
    }


    /**
     * 释放促销政策使用明细
     * @param orderNo
     * @return
     */
    @ApiOperation(value = "释放促销政策使用明细")
    @PostMapping("unlockPromotionPolicyOrderDetail")
    @CrmLog
    public Result<Boolean> unlockPromotionPolicyOrderDetail(@RequestParam String orderNo){
        Result result = new Result();
        Boolean flag = dmsPromotionPolicyOrderDetailService.unlockPromotionPolicyOrderDetail(orderNo);
        result.setResult(flag);
        return result;
    }


    /**
     * 回滚促销政策使用明细
     * @param orderNo
     * @return
     */
    @ApiOperation(value = "回滚促销政策使用明细")
    @PostMapping("rollbackPromotionPolicyOrderDetail")
    @CrmLog
    public Result<Boolean> rollbackPromotionPolicyOrderDetail(@RequestParam String orderNo){
        Result result = new Result();
        Boolean flag = dmsPromotionPolicyOrderDetailService.rollbackPromotionPolicyOrderDetail(orderNo);
        result.setResult(flag);
        return result;
    }
}
